/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.module;

import com.codahale.metrics.MetricRegistry;
import com.flipkart.drift.api.config.DriftConfiguration;
import com.flipkart.drift.api.config.RedisConfiguration;
import com.flipkart.drift.api.exception.JerseyViolationInformativeExceptionMapper;
import com.flipkart.drift.api.exception.mapper.ApiExceptionMapper;
import com.flipkart.drift.persistence.dao.ConnectionType;
import com.flipkart.drift.persistence.dao.IConnectionProvider;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.netflix.config.DynamicProperty;
import io.dropwizard.setup.Environment;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisSentinelPool;

public class WorkflowClientModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(WorkflowClientModule.class);
    private final RedisConfiguration redisConfiguration;
    private final JedisSentinelPool jedisSentinelPool;
    private final Environment environment;
    private final DriftConfiguration driftConfiguration;

    public WorkflowClientModule(DriftConfiguration driftConfiguration, Environment environment, MetricRegistry metricRegistry) {
        this.redisConfiguration = driftConfiguration.getRedisConfiguration();
        this.environment = environment;
        this.driftConfiguration = driftConfiguration;
        this.jedisSentinelPool = this.provideJedisPool();
    }

    private JedisSentinelPool provideJedisPool() {
        try {
            RedisConfiguration redisConfiguration = this.redisConfiguration;
            String hosts = redisConfiguration.getSentinels();
            StringTokenizer strTkn = new StringTokenizer(hosts, ",");
            ArrayList<String> hostList = new ArrayList<String>();
            while (strTkn.hasMoreTokens()) {
                hostList.add(strTkn.nextToken());
            }
            HashSet sentinels = new HashSet(hostList);
            GenericObjectPoolConfig<?> genericObjectPoolConfig = WorkflowClientModule.getGenericObjectPoolConfig(redisConfiguration);
            return new JedisSentinelPool(redisConfiguration.getMaster(), sentinels, genericObjectPoolConfig, redisConfiguration.getPassword());
        }
        catch (Exception e) {
            log.error("Failed to Connected to RedisDao Server {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private static GenericObjectPoolConfig<?> getGenericObjectPoolConfig(RedisConfiguration redisConfiguration) {
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(-1L);
        genericObjectPoolConfig.setMaxTotal(redisConfiguration.getMaxTotal());
        genericObjectPoolConfig.setTestOnBorrow(redisConfiguration.isTestOnBorrow());
        genericObjectPoolConfig.setMaxWaitMillis((long)redisConfiguration.getMaxWaitMillis());
        genericObjectPoolConfig.setBlockWhenExhausted(redisConfiguration.isBlockWhenExhausted());
        genericObjectPoolConfig.setMaxIdle(redisConfiguration.getMaxIdle());
        genericObjectPoolConfig.setMinIdle(redisConfiguration.getMinIdle());
        return genericObjectPoolConfig;
    }

    private void addExceptionMappers() {
        this.environment.jersey().getResourceConfig().register(ApiExceptionMapper.class);
        this.environment.jersey().getResourceConfig().register(JerseyViolationInformativeExceptionMapper.class);
    }

    private static void applyHadoopIdentity(DriftConfiguration driftConfiguration) {
        try {
            String loginUser;
            String userName = driftConfiguration.getHadoopUserName();
            if (StringUtils.isNotBlank((CharSequence)userName)) {
                System.setProperty("HADOOP_USER_NAME", userName);
            }
            if (StringUtils.isNotBlank((CharSequence)(loginUser = driftConfiguration.getHadoopLoginUser()))) {
                UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)loginUser));
            }
        }
        catch (Exception e) {
            log.warn("Unable to apply Hadoop identity from configuration: {}", (Object)e.getMessage());
        }
    }

    private static void populateBasicFields(Configuration configuration) {
        configuration.set("hbase.zookeeper.property.clientPort", "2181");
        configuration.set("zookeeper.session.timeout", "60000");
        configuration.set("zookeeper.recovery.retry", "3");
        configuration.set("hbase.client.retries.number", "3");
        configuration.set("hbase.rpc.timeout", "6000");
        configuration.set("hbase.client.ipc.pool.size", "20");
        configuration.set("hbase.client.operation.timeout", "6000");
        configuration.set("hbase.rpc.shortoperation.timeout", "4000");
        configuration.set("hbase.client.scanner.timeout.period", "120000");
        configuration.set("hbase.client.max.perserver.tasks", "40");
        configuration.set("hbase.client.max.perregion.tasks", "4");
        configuration.set("hbase.client.ipc.pool.type", "RoundRobinPool");
        configuration.set("hbase.hconnection.threads.max", "128");
    }

    protected void configure() {
        this.addExceptionMappers();
        this.bind(Connection.class).annotatedWith((Annotation)Names.named((String)ConnectionType.HOT.name())).toProvider(ConnectionProviderWorker.class).asEagerSingleton();
        this.bind(IConnectionProvider.class).to(ConnectionProvider.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    public JedisSentinelPool getJedisSentinelPool() {
        return this.jedisSentinelPool;
    }

    @Provides
    @Singleton
    public DriftConfiguration getDriftConfiguration() {
        return this.driftConfiguration;
    }

    public static class ConnectionProviderWorker
    implements Provider<Connection> {
        private final DriftConfiguration driftConfiguration;

        @Inject
        public ConnectionProviderWorker(DriftConfiguration driftConfiguration) {
            this.driftConfiguration = driftConfiguration;
        }

        public Connection get() {
            String zkQuorum;
            try {
                zkQuorum = DynamicProperty.getInstance((String)"zookeeper.quorum.hot").getString();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to fetch zookeeperQuorumHot from config", e);
            }
            if (StringUtils.isEmpty((CharSequence)zkQuorum)) {
                log.error("ZOOKEEPER_QUORUM_WORKER not found in config service property");
                throw new RuntimeException("ZOOKEEPER_QUORUM_WORKER not found in config service property");
            }
            Configuration configuration = HBaseConfiguration.create();
            configuration.set("hbase.zookeeper.quorum", zkQuorum);
            WorkflowClientModule.applyHadoopIdentity(this.driftConfiguration);
            WorkflowClientModule.populateBasicFields(configuration);
            try {
                return ConnectionFactory.createConnection((Configuration)configuration);
            }
            catch (Exception e) {
                log.error("Error while creating connection to HBase", (Throwable)e);
                throw new RuntimeException("Failed to create HBase connection", e);
            }
        }
    }

    public static class ConnectionProvider
    implements IConnectionProvider {
        private final Injector injector;

        @Inject
        public ConnectionProvider(Injector injector) {
            this.injector = injector;
        }

        public Connection getConnection(ConnectionType connectionType) {
            return (Connection)this.injector.getInstance(Key.get(Connection.class, (Annotation)Names.named((String)connectionType.name())));
        }

        public boolean isDegraded() {
            return false;
        }
    }
}

