/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.filters;

import com.flipkart.drift.api.filters.RequestThreadContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Provider
public class ResponseFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ResponseFilter.class);

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) {
        containerResponseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)"*");
        containerResponseContext.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"GET, POST, PUT, OPTIONS");
        String requestHeader = (String)containerRequestContext.getHeaders().getFirst((Object)"Access-Control-Request-Headers");
        if (requestHeader != null) {
            containerResponseContext.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)requestHeader);
        }
        containerResponseContext.getHeaders().add((Object)"X_SERVER_TRACE_ID", (Object)MDC.get((String)"id"));
        this.removeFromMDC();
    }

    private void removeFromMDC() {
        MDC.remove((String)"id");
        RequestThreadContext.remove();
    }
}

