/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.filters;

import java.util.HashMap;
import java.util.Map;

public class RequestThreadContext {
    private static ThreadLocal<RequestThreadContext> threadLocal = ThreadLocal.withInitial(RequestThreadContext::new);
    private String clientId;
    private Boolean perfFlag;
    private String tenant;
    private String username;

    public static RequestThreadContext get() {
        return threadLocal.get();
    }

    public static void remove() {
        threadLocal.remove();
    }

    public void clear() {
        this.clientId = null;
        this.tenant = null;
        this.perfFlag = null;
        this.username = null;
    }

    public Map<String, String> getLegacyThreadContext() {
        HashMap<String, String> threadContext = new HashMap<String, String>();
        threadContext.put("tenant", this.tenant);
        threadContext.put("userName", this.username);
        threadContext.put("clientId", this.clientId);
        threadContext.put("perfFlag", String.valueOf(this.perfFlag));
        return threadContext;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Boolean getPerfFlag() {
        return this.perfFlag;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getUsername() {
        return this.username;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setPerfFlag(Boolean perfFlag) {
        this.perfFlag = perfFlag;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestThreadContext)) {
            return false;
        }
        RequestThreadContext other = (RequestThreadContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$perfFlag = this.getPerfFlag();
        Boolean other$perfFlag = other.getPerfFlag();
        if (this$perfFlag == null ? other$perfFlag != null : !((Object)this$perfFlag).equals(other$perfFlag)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !this$username.equals(other$username));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestThreadContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $perfFlag = this.getPerfFlag();
        result = result * 59 + ($perfFlag == null ? 43 : ((Object)$perfFlag).hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        return result;
    }

    public String toString() {
        return "RequestThreadContext(clientId=" + this.getClientId() + ", perfFlag=" + this.getPerfFlag() + ", tenant=" + this.getTenant() + ", username=" + this.getUsername() + ")";
    }
}

