/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.filters;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.drift.api.exception.ApiException;
import com.flipkart.drift.api.filters.RequestThreadContext;
import com.flipkart.drift.commons.utils.MachineHelper;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.UUID;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.message.internal.ReaderWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Provider
public class RequestFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(RequestFilter.class);
    public static final String TENANT_HEADER = "X_TENANT_ID";
    public static final String CLIENT_HEADER = "X_CLIENT_ID";
    public static final String X_PERF_HEADER = "X-PERF-TEST";
    public static final String X_PERF_HEADER_UNDERSCORE = "X_PERF_TEST";
    public static final String USERNAME_HEADER = "X_USERNAME_ID";
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss-SSS");
    private final ObjectMapper objectMapper;

    @Inject
    public RequestFilter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        RequestThreadContext.get().clear();
        this.setTransactionId();
        MultivaluedMap headers = containerRequestContext.getHeaders();
        try {
            log.info("Headers : {}", (Object)this.objectMapper.writeValueAsString((Object)headers));
        }
        catch (IOException e) {
            log.info("Headers: {}", (Object)headers);
        }
        this.logIncomingRequest(containerRequestContext, (MultivaluedMap<String, String>)headers);
        this.extractHeaders((MultivaluedMap<String, String>)headers);
        this.setPerfRequestHeader((MultivaluedMap<String, String>)headers);
        log.info(RequestThreadContext.get().toString());
    }

    private void logIncomingRequest(ContainerRequestContext containerRequestContext, MultivaluedMap<String, String> headers) {
        String url = containerRequestContext.getUriInfo().getAbsolutePath().toString();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = containerRequestContext.getEntityStream();
        try {
            String requestHeaders = this.objectMapper.writeValueAsString(headers);
            ReaderWriter.writeTo((InputStream)in, (OutputStream)out);
            byte[] requestEntity = out.toByteArray();
            containerRequestContext.setEntityStream((InputStream)new ByteArrayInputStream(requestEntity));
            String body = out.toString();
            log.info("Request url: {} \n Body {} \n Headers {}", new Object[]{url, body, requestHeaders});
        }
        catch (IOException e) {
            log.error("Error in serializing {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(Response.Status.BAD_REQUEST, "Error in serializing {}", e.getMessage());
        }
    }

    private void extractHeaders(MultivaluedMap<String, String> headers) {
        Optional<String> tenant = Optional.ofNullable((String)headers.getFirst((Object)TENANT_HEADER));
        Optional<String> client = Optional.ofNullable((String)headers.getFirst((Object)CLIENT_HEADER));
        Optional<String> username = Optional.ofNullable((String)headers.getFirst((Object)USERNAME_HEADER));
        if (tenant.isEmpty() || client.isEmpty()) {
            throw new ApiException(Response.Status.BAD_REQUEST, "Headers are not valid , Headers required X_TENANT_ID, X_CLIENT_ID");
        }
        if (username.isEmpty()) {
            username = client;
        }
        RequestThreadContext.get().setTenant(tenant.get());
        RequestThreadContext.get().setClientId(client.get());
        RequestThreadContext.get().setUsername(username.get());
    }

    private void setTransactionId() {
        StringBuilder transactionId = new StringBuilder("DRIFT-");
        transactionId.append(LocalDateTime.now().format(dateTimeFormatter)).append("-").append(String.valueOf(UUID.randomUUID().getLeastSignificantBits()), 1, 6).append("-").append(MachineHelper.getMachineName());
        MDC.put((String)"id", (String)transactionId.toString());
        log.info("Transaction Id generated : {}", (Object)transactionId);
    }

    private void setPerfRequestHeader(MultivaluedMap<String, String> headers) {
        boolean perfHeaderFlag = headers.containsKey((Object)X_PERF_HEADER) && ((String)headers.getFirst((Object)X_PERF_HEADER)).toLowerCase().compareTo("true") == 0 || headers.containsKey((Object)X_PERF_HEADER_UNDERSCORE) && ((String)headers.getFirst((Object)X_PERF_HEADER_UNDERSCORE)).toLowerCase().compareTo("true") == 0;
        RequestThreadContext.get().setPerfFlag(perfHeaderFlag);
    }
}

