/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.exception;

import com.flipkart.drift.commons.model.client.response.ErrorResponse;
import io.dropwizard.jersey.validation.ConstraintMessage;
import io.dropwizard.jersey.validation.JerseyViolationException;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.jersey.server.model.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class JerseyViolationInformativeExceptionMapper
implements ExceptionMapper<JerseyViolationException> {
    private static final Logger log = LoggerFactory.getLogger(JerseyViolationInformativeExceptionMapper.class);

    public Response toResponse(JerseyViolationException exception) {
        Set violations = exception.getConstraintViolations();
        Invocable invocable = exception.getInvocable();
        List<String> errors = exception.getConstraintViolations().stream().map(violation -> ConstraintMessage.getMessage((ConstraintViolation)violation, (Invocable)invocable)).toList();
        int status = ConstraintMessage.determineStatus((Set)violations, (Invocable)invocable);
        ErrorResponse errorResponse = new ErrorResponse(MDC.get((String)"id"), exception.getClass(), errors.toString(), violations.toString(), status);
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorResponse).build();
    }
}

