/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.bootstrap;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.flipkart.drift.api.config.DriftConfiguration;
import com.flipkart.drift.api.exception.mapper.ApiExceptionMapper;
import com.flipkart.drift.api.filters.RequestFilter;
import com.flipkart.drift.api.filters.ResponseFilter;
import com.flipkart.drift.api.module.WorkflowClientModule;
import com.flipkart.drift.api.resources.NodeDefinitionResource;
import com.flipkart.drift.api.resources.WorkflowDefinitionResource;
import com.flipkart.drift.api.resources.WorkflowResource;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicURLConfiguration;
import io.dropwizard.Application;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.TimeZone;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.text.StringSubstitutor;

public class DriftApplication
extends Application<DriftConfiguration> {
    private MetricRegistry metricRegistry;

    public static void main(String[] args) throws Exception {
        new DriftApplication().run(args);
    }

    public void initialize(Bootstrap<DriftConfiguration> bootstrap) {
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StringSubstitutor)new EnvironmentVariableSubstitutor(false)));
        this.metricRegistry = bootstrap.getMetricRegistry();
        ObjectMapper objectMapper = bootstrap.getObjectMapper();
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setTimeZone(TimeZone.getDefault());
        objectMapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
    }

    public void run(DriftConfiguration configuration, Environment environment) {
        ConcurrentCompositeConfiguration compositeConfiguration = DriftApplication.getConcurrentCompositeConfiguration(configuration);
        DynamicPropertyFactory.initWithConfigurationSource((AbstractConfiguration)compositeConfiguration);
        Injector injector = Guice.createInjector((Module[])new Module[]{new WorkflowClientModule(configuration, environment, this.metricRegistry)});
        environment.jersey().register(injector.getInstance(WorkflowResource.class));
        environment.jersey().register(injector.getInstance(NodeDefinitionResource.class));
        environment.jersey().register(injector.getInstance(WorkflowDefinitionResource.class));
        environment.jersey().register(injector.getInstance(RequestFilter.class));
        environment.jersey().register(injector.getInstance(ResponseFilter.class));
        environment.jersey().register(injector.getInstance(ApiExceptionMapper.class));
        JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).build();
        reporter.start();
    }

    private static ConcurrentCompositeConfiguration getConcurrentCompositeConfiguration(DriftConfiguration configuration) {
        DynamicURLConfiguration dynamicConfiguration = new DynamicURLConfiguration(50000, 20000, false, new String[]{configuration.getHbasePropertiesPath()});
        ConcurrentCompositeConfiguration compositeConfiguration = new ConcurrentCompositeConfiguration();
        compositeConfiguration.addConfiguration((AbstractConfiguration)dynamicConfiguration);
        return compositeConfiguration;
    }
}

