/*
 * Decompiled with CFR 0.152.
 */
package org.dkv.client;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.dkv.client.DKVNodeSet;
import org.dkv.client.DKVNodeType;
import org.dkv.client.Utils;

public class DKVShard {
    private final String name;
    private final Map<DKVNodeType, DKVNodeSet> topology;

    public DKVShard(String name, Map<DKVNodeType, DKVNodeSet> topology) {
        Utils.checkf(name != null && !name.trim().isEmpty(), IllegalArgumentException.class, "shard name must be provided", new Object[0]);
        this.validate(topology);
        this.name = name;
        this.topology = Collections.unmodifiableMap(topology);
    }

    public String getName() {
        return this.name;
    }

    public DKVNodeSet getNodesByType(DKVNodeType ... nodeType) {
        Utils.checkf(this.topology != null, IllegalStateException.class, "topology is not initialized", new Object[0]);
        for (DKVNodeType dkvNodeType : nodeType) {
            if (!this.topology.containsKey((Object)dkvNodeType)) continue;
            return this.topology.get((Object)dkvNodeType);
        }
        throw new IllegalArgumentException("valid DKV node type must be given");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DKVShard dkvShard = (DKVShard)o;
        return this.name.equals(dkvShard.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "DKVShard{name='" + this.name + '\'' + ", topology=" + this.topology + '}';
    }

    private void validate(Map<DKVNodeType, DKVNodeSet> topology) {
        Utils.checkf(topology != null && !topology.isEmpty(), IllegalArgumentException.class, "topology must be given", new Object[0]);
        for (Map.Entry<DKVNodeType, DKVNodeSet> topEntry : topology.entrySet()) {
            DKVNodeType nodeType = topEntry.getKey();
            DKVNodeSet nodes = topEntry.getValue();
            Utils.checkf(nodes != null, IllegalArgumentException.class, "DKV nodes must be given for node type: %s", nodeType.name());
        }
    }

    private DKVShard() {
        this.name = null;
        this.topology = null;
    }
}

