/*
 * Decompiled with CFR 0.152.
 */
package org.dkv.client;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.google.protobuf.ByteString;
import dkv.serverpb.Api;
import dkv.serverpb.DKVGrpc;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.dkv.client.ConnectionOptions;
import org.dkv.client.DKVClient;
import org.dkv.client.DKVEntry;
import org.dkv.client.DKVException;
import org.dkv.client.KV;
import org.dkv.client.Utils;
import org.dkv.client.metrics.MetricsInterceptor;

public class SimpleDKVClient
implements DKVClient {
    private static final MetricRegistry metrics = new MetricRegistry();
    private final DKVGrpc.DKVBlockingStub blockingStub;
    private final ManagedChannel channel;
    private final JmxReporter reporter;
    private final ConnectionOptions connectionOptions;
    private static final int DEFAULT_BUF_SIZE = 0x100000;

    @Deprecated
    public SimpleDKVClient(String dkvHost, int dkvPort, String metricPrefix) {
        this(SimpleDKVClient.getManagedChannelBuilder(dkvHost, dkvPort), ConnectionOptions.builder().metricPrefix(metricPrefix).build());
    }

    @Deprecated
    public SimpleDKVClient(String dkvHost, int dkvPort, String authority, String metricPrefix) {
        this(SimpleDKVClient.getManagedChannelBuilder(dkvHost, dkvPort, authority), ConnectionOptions.builder().metricPrefix(metricPrefix).build());
    }

    @Deprecated
    public SimpleDKVClient(String dkvTarget, String metricPrefix) {
        this(SimpleDKVClient.getManagedChannelBuilder(dkvTarget), ConnectionOptions.builder().metricPrefix(metricPrefix).build());
    }

    @Deprecated
    public SimpleDKVClient(String dkvTarget, String authority, String metricPrefix) {
        this(SimpleDKVClient.getManagedChannelBuilder(dkvTarget, authority), ConnectionOptions.builder().metricPrefix(metricPrefix).build());
    }

    public SimpleDKVClient(String dkvTarget, @NonNull ConnectionOptions options) {
        this(SimpleDKVClient.getManagedChannelBuilder(dkvTarget), options);
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
    }

    public SimpleDKVClient(String dkvTarget, @NonNull String authority, @NonNull ConnectionOptions options) {
        this(SimpleDKVClient.getManagedChannelBuilder(dkvTarget, authority), options);
        if (authority == null) {
            throw new NullPointerException("authority is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
    }

    @Override
    public void put(String key, String value) {
        this.put(ByteString.copyFromUtf8((String)key), ByteString.copyFromUtf8((String)value), 0L);
    }

    @Override
    public void put(byte[] key, byte[] value) {
        this.put(ByteString.copyFrom((byte[])key), ByteString.copyFrom((byte[])value), 0L);
    }

    @Override
    public void put(String key, String value, long expiryTS) {
        this.put(ByteString.copyFromUtf8((String)key), ByteString.copyFromUtf8((String)value), expiryTS);
    }

    @Override
    public void put(byte[] key, byte[] value, long expiryTS) {
        this.put(ByteString.copyFrom((byte[])key), ByteString.copyFrom((byte[])value), expiryTS);
    }

    @Override
    public void put(KV.Strings ... items) {
        Api.MultiPutRequest.Builder multiPutReqBuilder = Api.MultiPutRequest.newBuilder();
        for (KV.Strings kv : items) {
            Api.PutRequest.Builder putReqBuilder = Api.PutRequest.newBuilder();
            Api.PutRequest putReq = putReqBuilder.setKey(ByteString.copyFromUtf8((String)((String)kv.getKey()))).setValue(ByteString.copyFromUtf8((String)((String)kv.getValue()))).setExpireTS(kv.getExpiryTS()).build();
            multiPutReqBuilder.addPutRequest(putReq);
        }
        Api.MultiPutRequest multiPutReq = multiPutReqBuilder.build();
        Api.PutResponse response = ((DKVGrpc.DKVBlockingStub)this.blockingStub.withDeadlineAfter(this.connectionOptions.getWriteTimeout(), TimeUnit.MILLISECONDS)).multiPut(multiPutReq);
        Api.Status status = response.getStatus();
        if (status.getCode() != 0) {
            throw new DKVException(status, "MultiPut", new Object[]{items});
        }
    }

    @Override
    public void put(KV.Bytes ... items) {
        Api.MultiPutRequest.Builder multiPutReqBuilder = Api.MultiPutRequest.newBuilder();
        for (KV.Bytes kv : items) {
            Api.PutRequest.Builder putReqBuilder = Api.PutRequest.newBuilder();
            Api.PutRequest putReq = putReqBuilder.setKey(ByteString.copyFrom((byte[])((byte[])kv.getKey()))).setValue(ByteString.copyFrom((byte[])((byte[])kv.getValue()))).setExpireTS(kv.getExpiryTS()).build();
            multiPutReqBuilder.addPutRequest(putReq);
        }
        Api.MultiPutRequest multiPutReq = multiPutReqBuilder.build();
        Api.PutResponse response = ((DKVGrpc.DKVBlockingStub)this.blockingStub.withDeadlineAfter(this.connectionOptions.getWriteTimeout(), TimeUnit.MILLISECONDS)).multiPut(multiPutReq);
        Api.Status status = response.getStatus();
        if (status.getCode() != 0) {
            throw new DKVException(status, "MultiPut", new Object[]{items});
        }
    }

    @Override
    public boolean compareAndSet(byte[] key, byte[] expect, byte[] update) {
        ByteString expectByteStr = expect != null ? ByteString.copyFrom((byte[])expect) : ByteString.EMPTY;
        return this.cas(ByteString.copyFrom((byte[])key), expectByteStr, ByteString.copyFrom((byte[])update), 0L);
    }

    @Override
    public boolean compareAndSet(byte[] key, byte[] expect, byte[] update, long expiryTS) {
        ByteString expectByteStr = expect != null ? ByteString.copyFrom((byte[])expect) : ByteString.EMPTY;
        return this.cas(ByteString.copyFrom((byte[])key), expectByteStr, ByteString.copyFrom((byte[])update), expiryTS);
    }

    @Override
    public long incrementAndGet(byte[] key) {
        return this.addAndGet(key, 1L);
    }

    @Override
    public long decrementAndGet(byte[] key) {
        return this.addAndGet(key, -1L);
    }

    @Override
    public long addAndGet(byte[] key, long delta) {
        ByteString keyByteStr = ByteString.copyFrom((byte[])key);
        return this.addAndGet(keyByteStr, delta);
    }

    @Override
    public long addAndGet(byte[] key, long delta, long expiryTS) {
        ByteString keyByteStr = ByteString.copyFrom((byte[])key);
        return this.addAndGet(keyByteStr, delta, expiryTS);
    }

    @Override
    public String get(Api.ReadConsistency consistency, String key) {
        ByteString value = this.get(consistency, ByteString.copyFromUtf8((String)key));
        return value.toStringUtf8();
    }

    @Override
    public byte[] get(Api.ReadConsistency consistency, byte[] key) {
        ByteString value = this.get(consistency, ByteString.copyFrom((byte[])key));
        return value.toByteArray();
    }

    @Override
    public KV.Strings[] multiGet(Api.ReadConsistency consistency, String[] keys) {
        LinkedList<ByteString> keyByteStrs = new LinkedList<ByteString>();
        for (String key : keys) {
            keyByteStrs.add(ByteString.copyFromUtf8((String)key));
        }
        List<Api.KVPair> kvPairs = this.multiGet(consistency, keyByteStrs);
        KV.Strings[] result = new KV.Strings[kvPairs.size()];
        int idx = 0;
        for (Api.KVPair kvPair : kvPairs) {
            result[idx++] = new KV.Strings(kvPair.getKey().toStringUtf8(), kvPair.getValue().toStringUtf8());
        }
        return result;
    }

    @Override
    public KV.Bytes[] multiGet(Api.ReadConsistency consistency, byte[][] keys) {
        LinkedList<ByteString> keyByteStrs = new LinkedList<ByteString>();
        for (byte[] key : keys) {
            keyByteStrs.add(ByteString.copyFrom((byte[])key));
        }
        List<Api.KVPair> kvPairs = this.multiGet(consistency, keyByteStrs);
        KV.Bytes[] result = new KV.Bytes[kvPairs.size()];
        int idx = 0;
        for (Api.KVPair kvPair : kvPairs) {
            result[idx++] = new KV.Bytes(kvPair.getKey().toByteArray(), kvPair.getValue().toByteArray());
        }
        return result;
    }

    @Override
    public void delete(String key) {
        this.delete(ByteString.copyFromUtf8((String)key));
    }

    @Override
    public void delete(byte[] key) {
        this.delete(ByteString.copyFrom((byte[])key));
    }

    @Override
    public Iterator<DKVEntry> iterate(String startKey) {
        return this.iterate(ByteString.copyFromUtf8((String)startKey), ByteString.EMPTY);
    }

    @Override
    public Iterator<DKVEntry> iterate(byte[] startKey) {
        return this.iterate(ByteString.copyFrom((byte[])startKey), ByteString.EMPTY);
    }

    @Override
    public Iterator<DKVEntry> iterate(String startKey, String keyPref) {
        return this.iterate(ByteString.copyFromUtf8((String)startKey), ByteString.copyFromUtf8((String)keyPref));
    }

    @Override
    public Iterator<DKVEntry> iterate(byte[] startKey, byte[] keyPref) {
        return this.iterate(ByteString.copyFrom((byte[])startKey), ByteString.copyFrom((byte[])keyPref));
    }

    @Override
    public void close() {
        this.reporter.stop();
        this.channel.shutdownNow();
        try {
            this.channel.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private SimpleDKVClient(ManagedChannelBuilder<?> channelBuilder, ConnectionOptions options) {
        this.reporter = JmxReporter.forRegistry((MetricRegistry)metrics).inDomain(options.getMetricPrefix()).convertRatesTo(TimeUnit.MILLISECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        this.reporter.start();
        this.channel = channelBuilder.build();
        this.blockingStub = (DKVGrpc.DKVBlockingStub)DKVGrpc.newBlockingStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{new MetricsInterceptor(metrics)});
        this.connectionOptions = options;
    }

    private Iterator<DKVEntry> iterate(ByteString startKey, ByteString keyPref) {
        Api.IterateRequest.Builder iterReqBuilder = Api.IterateRequest.newBuilder();
        Api.IterateRequest iterReq = iterReqBuilder.setKeyPrefix(keyPref).setStartKey(startKey).build();
        Iterator<Api.IterateResponse> iterRes = this.blockingStub.iterate(iterReq);
        return new DKVEntryIterator(iterRes);
    }

    private void delete(ByteString keyByteStr) {
        Api.DeleteRequest.Builder delReqBuilder = Api.DeleteRequest.newBuilder();
        Api.DeleteRequest delReq = delReqBuilder.setKey(keyByteStr).build();
        Api.Status status = ((DKVGrpc.DKVBlockingStub)this.blockingStub.withDeadlineAfter(this.connectionOptions.getWriteTimeout(), TimeUnit.MILLISECONDS)).delete(delReq).getStatus();
        if (status.getCode() != 0) {
            throw new DKVException(status, "Delete", new Object[]{keyByteStr.toByteArray()});
        }
    }

    private void put(ByteString keyByteStr, ByteString valByteStr, long expiryTS) {
        Api.PutRequest.Builder putReqBuilder = Api.PutRequest.newBuilder();
        Api.PutRequest putReq = putReqBuilder.setKey(keyByteStr).setValue(valByteStr).setExpireTS(expiryTS).build();
        Api.Status status = ((DKVGrpc.DKVBlockingStub)this.blockingStub.withDeadlineAfter(this.connectionOptions.getWriteTimeout(), TimeUnit.MILLISECONDS)).put(putReq).getStatus();
        if (status.getCode() != 0) {
            throw new DKVException(status, "Put", new Object[]{keyByteStr.toByteArray(), valByteStr.toByteArray()});
        }
    }

    private ByteString get(Api.ReadConsistency consistency, ByteString keyByteStr) {
        Api.GetRequest.Builder getReqBuilder = Api.GetRequest.newBuilder();
        Api.GetRequest getReq = getReqBuilder.setKey(keyByteStr).setReadConsistency(consistency).build();
        Api.GetResponse getRes = ((DKVGrpc.DKVBlockingStub)this.blockingStub.withDeadlineAfter(this.connectionOptions.getReadTimeout(), TimeUnit.MILLISECONDS)).get(getReq);
        Api.Status status = getRes.getStatus();
        if (status.getCode() != 0) {
            throw new DKVException(status, "Get", new Object[]{consistency, keyByteStr.toByteArray()});
        }
        return getRes.getValue();
    }

    private List<Api.KVPair> multiGet(Api.ReadConsistency consistency, List<ByteString> keyByteStrs) {
        Api.MultiGetRequest.Builder multiGetReqBuilder = Api.MultiGetRequest.newBuilder();
        Api.MultiGetRequest multiGetReq = multiGetReqBuilder.addAllKeys(keyByteStrs).setReadConsistency(consistency).build();
        Api.MultiGetResponse multiGetRes = ((DKVGrpc.DKVBlockingStub)this.blockingStub.withDeadlineAfter(this.connectionOptions.getReadTimeout(), TimeUnit.MILLISECONDS)).multiGet(multiGetReq);
        Api.Status status = multiGetRes.getStatus();
        if (status.getCode() != 0) {
            throw new DKVException(status, "MultiGet", new Object[]{consistency, keyByteStrs});
        }
        return multiGetRes.getKeyValuesList();
    }

    private long addAndGet(ByteString keyByteStr, long delta) {
        return this.addAndGet(keyByteStr, delta, 0L);
    }

    private long addAndGet(ByteString keyByteStr, long delta, long expiryTS) {
        long updatedVal;
        ByteString updatedValByteStr;
        ByteString expValByteStr;
        while (!this.cas(keyByteStr, expValByteStr = this.get(Api.ReadConsistency.LINEARIZABLE, keyByteStr), updatedValByteStr = Utils.covertToBytes(updatedVal = Utils.convertToLong(expValByteStr) + delta), expiryTS)) {
        }
        return updatedVal;
    }

    private boolean cas(ByteString keyByteStr, ByteString expectByteStr, ByteString updateByteStr, long expiryTS) {
        Api.CompareAndSetRequest.Builder casReqBuilder = Api.CompareAndSetRequest.newBuilder();
        Api.CompareAndSetRequest casReq = casReqBuilder.setKey(keyByteStr).setOldValue(expectByteStr).setNewValue(updateByteStr).setExpireTS(expiryTS).build();
        Api.CompareAndSetResponse casRes = ((DKVGrpc.DKVBlockingStub)this.blockingStub.withDeadlineAfter(this.connectionOptions.getWriteTimeout(), TimeUnit.MILLISECONDS)).compareAndSet(casReq);
        Api.Status status = casRes.getStatus();
        if (status.getCode() != 0) {
            throw new DKVException(status, "CompareAndSet", new Object[]{keyByteStr, expectByteStr, updateByteStr});
        }
        return casRes.getUpdated();
    }

    private static ManagedChannelBuilder<?> getManagedChannelBuilder(String dkvHost, int dkvPort) {
        Utils.checkf(dkvHost != null && !dkvHost.trim().isEmpty(), IllegalArgumentException.class, "Valid DKV hostname must be provided", new Object[0]);
        Utils.checkf(dkvPort > 0, IllegalArgumentException.class, "Valid DKV port must be provided", new Object[0]);
        return NettyChannelBuilder.forAddress((String)dkvHost, (int)dkvPort).usePlaintext().withOption(ChannelOption.SO_REUSEADDR, (Object)true).withOption(ChannelOption.SO_SNDBUF, (Object)0x100000).withOption(ChannelOption.SO_RCVBUF, (Object)0x100000);
    }

    private static ManagedChannelBuilder<?> getManagedChannelBuilder(String dkvHost, int dkvPort, String authority) {
        Utils.checkf(authority != null && !authority.trim().isEmpty(), IllegalArgumentException.class, "Valid authority must be provided", new Object[0]);
        return SimpleDKVClient.getManagedChannelBuilder(dkvHost, dkvPort).overrideAuthority(authority);
    }

    private static ManagedChannelBuilder<?> getManagedChannelBuilder(String dkvTarget) {
        Utils.checkf(dkvTarget != null && !dkvTarget.trim().isEmpty(), IllegalArgumentException.class, "Valid DKV hostname must be provided", new Object[0]);
        return NettyChannelBuilder.forTarget((String)dkvTarget).usePlaintext().withOption(ChannelOption.SO_REUSEADDR, (Object)true).withOption(ChannelOption.SO_SNDBUF, (Object)0x100000).withOption(ChannelOption.SO_RCVBUF, (Object)0x100000);
    }

    private static ManagedChannelBuilder<?> getManagedChannelBuilder(String dkvTarget, String authority) {
        Utils.checkf(authority != null && !authority.trim().isEmpty(), IllegalArgumentException.class, "Valid authority must be provided", new Object[0]);
        return SimpleDKVClient.getManagedChannelBuilder(dkvTarget).overrideAuthority(authority);
    }

    private static class DKVEntryIterator
    implements Iterator<DKVEntry> {
        private final Iterator<Api.IterateResponse> iterRes;

        DKVEntryIterator(Iterator<Api.IterateResponse> iterRes) {
            this.iterRes = iterRes;
        }

        @Override
        public boolean hasNext() {
            return this.iterRes.hasNext();
        }

        @Override
        public DKVEntry next() {
            Api.IterateResponse iterateResponse = this.iterRes.next();
            return new DKVEntry(iterateResponse);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

