/*
 * Decompiled with CFR 0.152.
 */
package org.dkv.client;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.dkv.client.DKVNode;
import org.dkv.client.Utils;

public class DKVNodeSet {
    private final String name;
    private final DKVNode[] nodes;
    private final AtomicInteger idx = new AtomicInteger(0);

    public DKVNodeSet(String name, Set<DKVNode> nodes) {
        Utils.checkf(name != null && !name.trim().isEmpty(), IllegalArgumentException.class, "DKV node set name must be given", new Object[0]);
        Utils.checkf(nodes != null && !nodes.isEmpty(), IllegalArgumentException.class, "DKV nodes must be given", new Object[0]);
        this.nodes = nodes.toArray(new DKVNode[0]);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DKVNode[] getNodes() {
        return this.nodes;
    }

    public DKVNode getNextNode() {
        if (this.nodes == null) {
            throw new IllegalStateException("this DKVNodeSet instance is not initialized");
        }
        int nextIdx = this.idx.getAndUpdate(id -> (id + 1) % this.nodes.length);
        return this.nodes[nextIdx];
    }

    private DKVNodeSet() {
        this.name = null;
        this.nodes = null;
    }

    public int getNumNodes() {
        return this.nodes != null ? this.nodes.length : 0;
    }
}

