/*
 * Decompiled with CFR 0.152.
 */
package org.dkv.client;

import com.google.protobuf.ByteString;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;

public class Utils {
    static void throwf(Class<? extends RuntimeException> excClass, String msg, Object ... keys) {
        Constructor<?>[] cons;
        String errMsg = String.format(msg, keys);
        for (Constructor<?> con : cons = excClass.getConstructors()) {
            Constructor<?> excClassCon = con;
            Class<?>[] parameterTypes = excClassCon.getParameterTypes();
            if (parameterTypes.length != 1 || parameterTypes[0] != String.class) continue;
            try {
                throw (RuntimeException)excClassCon.newInstance(errMsg);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    static void checkf(boolean condition, Class<? extends RuntimeException> excClass, String msg, Object ... keys) {
        if (!condition) {
            Utils.throwf(excClass, msg, keys);
        }
    }

    static long convertToLong(byte[] bts) {
        if (bts.length == 0) {
            return 0L;
        }
        return ByteBuffer.wrap(bts).getLong();
    }

    static long convertToLong(ByteString byteStr) {
        if (byteStr.isEmpty()) {
            return 0L;
        }
        return byteStr.asReadOnlyByteBuffer().getLong();
    }

    static ByteString covertToBytes(long val) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).putLong(val);
        return ByteString.copyFrom((byte[])byteBuffer.array());
    }
}

