/*
 * Decompiled with CFR 0.152.
 */
package org.dkv.client;

import java.util.Objects;
import org.dkv.client.Utils;

public class DKVNode {
    private static final int MAX_PORT_VALUE = 65535;
    private final String host;
    private final int port;

    public DKVNode(String host, int port) {
        Utils.checkf(host != null && !host.trim().isEmpty(), IllegalArgumentException.class, "host must be provided", new Object[0]);
        Utils.checkf(port > 0 && port <= 65535, IllegalArgumentException.class, "given port %d is invalid", port);
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAddress() {
        return String.format("%s:%d", this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DKVNode dkvNode = (DKVNode)o;
        return this.port == dkvNode.port && this.host.equals(dkvNode.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    private DKVNode() {
        this.host = null;
        this.port = -1;
    }
}

