/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.sample.client.common.utils;

import com.flipkart.aesop.sample.client.common.utils.MysqlDataTypes;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.avro.util.Utf8;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class AvroToMysqlMapper {
    private static final Logger LOGGER = LogFactory.getLogger(AvroToMysqlMapper.class);

    public static Object avroToMysqlType(Object value, MysqlDataTypes mysqlType) throws IllegalArgumentException {
        if (value instanceof ByteBuffer) {
            if (mysqlType == MysqlDataTypes.BIT || mysqlType == MysqlDataTypes.TINYTEXT || mysqlType == MysqlDataTypes.MEDIUMTEXT || mysqlType == MysqlDataTypes.LONGTEXT || mysqlType == MysqlDataTypes.TEXT) {
                return new String(((ByteBuffer)value).array());
            }
            if (mysqlType == MysqlDataTypes.BLOB || mysqlType == MysqlDataTypes.TINYBLOB || mysqlType == MysqlDataTypes.MEDIUMBLOB || mysqlType == MysqlDataTypes.LONGBLOB) {
                return value;
            }
            LOGGER.error("Incompatible types java.nio.ByteBuffer and " + mysqlType.toString());
            throw new IllegalArgumentException("Incompatible types java.nio.ByteBuffer and " + mysqlType.toString());
        }
        if (value instanceof Long) {
            if (mysqlType == MysqlDataTypes.INT || mysqlType == MysqlDataTypes.INTEGER || mysqlType == MysqlDataTypes.TINYINT || mysqlType == MysqlDataTypes.MEDIUMINT || mysqlType == MysqlDataTypes.BIGINT || mysqlType == MysqlDataTypes.SET) {
                return value;
            }
            if (mysqlType == MysqlDataTypes.DATE) {
                return new Date((Long)value);
            }
            if (mysqlType == MysqlDataTypes.TIMESTAMP || mysqlType == MysqlDataTypes.DATETIME) {
                return new Timestamp((Long)value);
            }
            if (mysqlType == MysqlDataTypes.TIME) {
                return new Time((Long)value);
            }
            LOGGER.error("Incompatible types Long and " + mysqlType.toString());
            throw new IllegalArgumentException("Incompatible types Long and " + mysqlType.toString());
        }
        if (value instanceof String) {
            if (mysqlType == MysqlDataTypes.CHAR || mysqlType == MysqlDataTypes.VARCHAR) {
                return value;
            }
            if (mysqlType == MysqlDataTypes.DECIMAL) {
                return new BigDecimal((String)value);
            }
            LOGGER.error("Incompatible types String and " + mysqlType.toString());
            throw new IllegalArgumentException("Incompatible types String and " + mysqlType.toString());
        }
        if (value instanceof Utf8) {
            if (mysqlType == MysqlDataTypes.CHAR || mysqlType == MysqlDataTypes.VARCHAR) {
                return value.toString();
            }
            if (mysqlType == MysqlDataTypes.DECIMAL) {
                return new BigDecimal(value.toString());
            }
            LOGGER.error("Incompatible types org.apache.avro.util.Utf8 and " + mysqlType.toString());
            throw new IllegalArgumentException("Incompatible types org.apache.avro.util.Utf8 and " + mysqlType.toString());
        }
        if (value instanceof Double) {
            if (mysqlType == MysqlDataTypes.DOUBLE || mysqlType == MysqlDataTypes.FLOAT) {
                return value;
            }
            LOGGER.error("Incompatible types Double and " + mysqlType.toString());
            throw new IllegalArgumentException("Incompatible types Double and " + mysqlType.toString());
        }
        if (value instanceof Integer) {
            if (mysqlType == MysqlDataTypes.SMALLINT || mysqlType == MysqlDataTypes.TINYINT || mysqlType == MysqlDataTypes.MEDIUMINT || mysqlType == MysqlDataTypes.INT || mysqlType == MysqlDataTypes.INTEGER || mysqlType == MysqlDataTypes.ENUM || mysqlType == MysqlDataTypes.YEAR) {
                return value;
            }
            LOGGER.error("Incompatible types Integer and " + mysqlType.toString());
            throw new IllegalArgumentException("Incompatible types Integer and " + mysqlType.toString());
        }
        if (value instanceof Float) {
            if (mysqlType == MysqlDataTypes.FLOAT) {
                return value;
            }
            LOGGER.error("Incompatible types Integer and " + mysqlType.toString());
            throw new IllegalArgumentException("Incompatible types Integer and " + mysqlType.toString());
        }
        if (value == null) {
            return null;
        }
        LOGGER.error("unsupported avro type ; avro type : " + value.getClass().toString());
        throw new IllegalArgumentException("unsupported avro type ; avro type : " + value.getClass().toString());
    }
}

