/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.impl.admin;

import com.flipkart.aesop.runtime.spi.admin.RuntimeConfigService;
import com.flipkart.aesop.runtime.spi.registry.AbstractRuntimeRegistry;
import com.flipkart.aesop.runtime.spring.RuntimeComponentContainer;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.trpr.platform.core.PlatformException;

public class RuntimeConfigServiceImpl
implements RuntimeConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeConfigServiceImpl.class);
    public static final String PREV_RUNTIME_FILE_PREFIX = "prev-";
    private RuntimeComponentContainer componentContainer;
    private Map<URI, List<ServerContainer>> configURItoRuntimeName = new HashMap<URI, List<ServerContainer>>();
    private List<AbstractRuntimeRegistry> registries = new ArrayList<AbstractRuntimeRegistry>();

    @Override
    public void addRuntimeRegistry(AbstractRuntimeRegistry registry) {
        this.registries.add(registry);
    }

    @Override
    public Resource getRuntimeConfig(String runtimeName) {
        for (URI configFile : this.configURItoRuntimeName.keySet()) {
            for (ServerContainer runtime : this.configURItoRuntimeName.get(configFile)) {
                if (!runtime.getComponentAdmin().getComponentName().equals(runtimeName)) continue;
                return new FileSystemResource(new File(configFile));
            }
        }
        return null;
    }

    @Override
    public void modifyRuntimeConfig(String runtimeName, ByteArrayResource modifiedRuntimeConfigFile) throws PlatformException {
        File oldRuntimeFile = null;
        try {
            oldRuntimeFile = this.getRuntimeConfig(runtimeName).getFile();
        }
        catch (IOException e1) {
            LOGGER.error("Config File for runtime: " + runtimeName + " not found. Returning");
            throw new PlatformException("File not found for runtime: " + runtimeName, (Throwable)e1);
        }
        if (!oldRuntimeFile.exists()) {
            LOGGER.error("Runtime Config File: " + oldRuntimeFile.getAbsolutePath() + " doesn't exist. Returning");
            throw new PlatformException("File not found: " + oldRuntimeFile.getAbsolutePath());
        }
        if (!oldRuntimeFile.canRead()) {
            LOGGER.error("No read permission for: " + oldRuntimeFile.getAbsolutePath() + ". Returning");
            throw new PlatformException("Read permissions not found for file: " + oldRuntimeFile.getAbsolutePath());
        }
        if (!oldRuntimeFile.canWrite()) {
            LOGGER.error("No write permission for: " + oldRuntimeFile.getAbsolutePath() + ". Write permissions are required to modify runtime config");
            throw new PlatformException("Required permissions not found for modifying file: " + oldRuntimeFile.getAbsolutePath());
        }
        this.createPrevConfigFile(runtimeName);
        try {
            this.upload(modifiedRuntimeConfigFile.getByteArray(), oldRuntimeFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("IOException while uploading file to path: " + oldRuntimeFile.getAbsolutePath());
            this.restorePrevConfigFile(runtimeName);
            throw new PlatformException((Throwable)e);
        }
        ServerContainer runtime = this.configURItoRuntimeName.get(oldRuntimeFile.toURI()).get(0);
        try {
            this.componentContainer.reloadRuntime(runtime, this.getRuntimeConfig(runtimeName));
        }
        catch (Exception e) {
            this.restorePrevConfigFile(runtimeName);
            this.componentContainer.loadComponent(this.getRuntimeConfig(runtimeName));
            throw new PlatformException((Throwable)e);
        }
        this.removePrevConfigFile(runtimeName);
    }

    @Override
    public void addRuntimeConfigPath(File runtimeFile, ServerContainer runtime) {
        if (this.configURItoRuntimeName.get(runtimeFile.toURI()) == null) {
            this.configURItoRuntimeName.put(runtimeFile.toURI(), new LinkedList());
        }
        this.configURItoRuntimeName.get(runtimeFile.toURI()).add(runtime);
    }

    @Override
    public void reinitRuntime(String runtimeName) throws Exception {
        for (AbstractRuntimeRegistry registry : this.registries) {
            if (registry.getRuntime(runtimeName) == null) continue;
            registry.reinitRuntime(runtimeName);
        }
    }

    @Override
    public List<ServerContainer> getAllRuntimes() {
        ArrayList<ServerContainer> list = new ArrayList<ServerContainer>();
        for (AbstractRuntimeRegistry registry : this.registries) {
            list.addAll(registry.getRuntimes());
        }
        return list;
    }

    private void createPrevConfigFile(String runtimeName) {
        File configFile = null;
        try {
            configFile = this.getRuntimeConfig(runtimeName).getFile();
        }
        catch (IOException e1) {
            LOGGER.error("Exception while getting runtime Config File", (Throwable)e1);
            throw new PlatformException("Exception while getting runtime Config File", (Throwable)e1);
        }
        File prevFile = new File(String.valueOf(configFile.getParent()) + "/" + PREV_RUNTIME_FILE_PREFIX + configFile.getName());
        if (configFile.exists()) {
            if (prevFile.exists()) {
                prevFile.delete();
            }
            configFile.renameTo(prevFile);
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error("IOException while clearing config File", (Throwable)e);
                throw new PlatformException("IOException while clearing config File", (Throwable)e);
            }
            prevFile.deleteOnExit();
        }
    }

    private void removePrevConfigFile(String runtimeName) {
        File configFile = null;
        try {
            configFile = this.getRuntimeConfig(runtimeName).getFile();
        }
        catch (IOException e) {
            LOGGER.error("IOException while getting runtime Config File", (Throwable)e);
        }
        String prevFilePath = String.valueOf(configFile.getParent()) + "/" + PREV_RUNTIME_FILE_PREFIX + configFile.getName();
        File prevFile = new File(prevFilePath);
        if (prevFile.exists()) {
            prevFile.delete();
        }
    }

    private void restorePrevConfigFile(String runtimeName) {
        File prevFile;
        File configFile = null;
        try {
            configFile = this.getRuntimeConfig(runtimeName).getFile();
        }
        catch (IOException e) {
            LOGGER.error("IOException while getting runtime config file", (Throwable)e);
        }
        if (configFile.exists()) {
            configFile.delete();
        }
        if ((prevFile = new File(String.valueOf(configFile.getParent()) + "/" + PREV_RUNTIME_FILE_PREFIX + configFile.getName())).exists()) {
            prevFile.renameTo(configFile);
        }
    }

    private void upload(byte[] fileContents, String destPath) throws IOException {
        File destFile = new File(destPath);
        if (destFile.exists()) {
            destFile.delete();
            destFile.createNewFile();
        }
        try {
            destFile.getParentFile().mkdirs();
        }
        catch (Exception e) {
            LOGGER.error("Unable to create directory structure for uploading file");
            throw new PlatformException("Unable to create directory structure for uploading file");
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        fos.write(fileContents);
    }

    public RuntimeComponentContainer getComponentContainer() {
        return this.componentContainer;
    }

    public void setComponentContainer(RuntimeComponentContainer componentContainer) {
        this.componentContainer = componentContainer;
    }
}

