/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.spring;

import com.flipkart.aesop.runtime.impl.admin.RuntimeConfigServiceImpl;
import com.flipkart.aesop.runtime.spi.admin.RuntimeConfigService;
import com.flipkart.aesop.runtime.spi.registry.AbstractRuntimeRegistry;
import com.flipkart.aesop.runtime.spring.registry.ServerContainerConfigInfo;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.event.PlatformEventProducer;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.model.event.PlatformEvent;
import org.trpr.platform.runtime.common.RuntimeVariables;
import org.trpr.platform.runtime.impl.bootstrapext.spring.ApplicationContextFactory;
import org.trpr.platform.runtime.impl.config.FileLocator;
import org.trpr.platform.runtime.spi.bootstrapext.BootstrapExtension;
import org.trpr.platform.runtime.spi.component.ComponentContainer;

public abstract class RuntimeComponentContainer
implements ComponentContainer {
    public static final String RUNTIME_MODULE_VAR = "com.flipkart.aesop.runtime.module.name";
    private static final Logger LOGGER = LogFactory.getLogger(RuntimeComponentContainer.class);
    private static final String DEFAULT_EVENT_PRODUCER = "platformEventProducer";
    private static final String CONFIG_SERVICE_BEAN = "configService";
    private static AbstractApplicationContext commonRuntimeBeansContext;
    private List<ServerContainerConfigInfo> runtimeConfigInfoList = new LinkedList<ServerContainerConfigInfo>();
    private BootstrapExtension[] loadedBootstrapExtensions;
    private ClassLoader tccl;
    private List<AbstractRuntimeRegistry> registries = new ArrayList<AbstractRuntimeRegistry>();
    private RuntimeConfigService configService;

    public static AbstractApplicationContext getCommonRuntimeBeansContext() {
        return commonRuntimeBeansContext;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void setLoadedBootstrapExtensions(BootstrapExtension ... bootstrapExtensions) {
        this.loadedBootstrapExtensions = bootstrapExtensions;
    }

    public void init() throws PlatformException {
        File[] runtimeBeansFiles;
        this.tccl = Thread.currentThread().getContextClassLoader();
        RuntimeVariables.getInstance().setVariable(RUNTIME_MODULE_VAR, this.getRuntimeModuleName());
        ApplicationContextFactory defaultCtxFactory = null;
        for (BootstrapExtension be : this.loadedBootstrapExtensions) {
            if (!ApplicationContextFactory.class.isAssignableFrom(be.getClass())) continue;
            defaultCtxFactory = (ApplicationContextFactory)be;
            break;
        }
        commonRuntimeBeansContext = new ClassPathXmlApplicationContext(new String[]{"packaged/common-runtime-config.xml"}, (ApplicationContext)defaultCtxFactory.getCommonBeansContext());
        this.runtimeConfigInfoList.add(new ServerContainerConfigInfo(new File("packaged/common-runtime-config.xml"), null, commonRuntimeBeansContext));
        this.configService = (RuntimeConfigServiceImpl)commonRuntimeBeansContext.getBean(CONFIG_SERVICE_BEAN);
        ((RuntimeConfigServiceImpl)this.configService).setComponentContainer(this);
        if (RuntimeVariables.getRuntimeNature().equalsIgnoreCase("SERVER")) {
            commonRuntimeBeansContext = new ClassPathXmlApplicationContext(new String[]{"packaged/common-runtime-server-nature-config.xml"}, (ApplicationContext)RuntimeComponentContainer.getCommonRuntimeBeansContext());
            this.runtimeConfigInfoList.add(new ServerContainerConfigInfo(new File("packaged/common-runtime-server-nature-config.xml"), null, RuntimeComponentContainer.getCommonRuntimeBeansContext()));
        }
        for (File runtimeBeansFile : runtimeBeansFiles = FileLocator.findFiles((String)this.getRuntimeConfigFileName())) {
            ServerContainerConfigInfo runtimeConfigInfo = new ServerContainerConfigInfo(runtimeBeansFile);
            this.loadRuntimeContext(runtimeConfigInfo);
            LOGGER.info("Loaded: " + runtimeBeansFile);
        }
        for (ServerContainerConfigInfo serverContainerConfigInfo : this.runtimeConfigInfoList) {
            String[] registryBeans;
            for (String registryBean : registryBeans = serverContainerConfigInfo.getRuntimeContext().getBeanNamesForType(AbstractRuntimeRegistry.class)) {
                AbstractRuntimeRegistry registry = (AbstractRuntimeRegistry)serverContainerConfigInfo.getRuntimeContext().getBean(registryBean);
                LOGGER.info("Found runtime registry: " + registry.getClass().getName());
                try {
                    AbstractRuntimeRegistry.InitedRuntimeInfo[] initedRuntimeInfos = registry.init(this.runtimeConfigInfoList);
                    LOGGER.info("Initialized runtime registry: " + registry.getClass().getName());
                    for (AbstractRuntimeRegistry.InitedRuntimeInfo initedRuntimeInfo : initedRuntimeInfos) {
                        this.configService.addRuntimeConfigPath(initedRuntimeInfo.getRuntimeConfigInfo().getXmlConfigFile(), initedRuntimeInfo.getInitedRuntime());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error initializing registry: " + registry.getClass().getName());
                    throw new PlatformException("Error initializing registry: " + registry.getClass().getName(), (Throwable)e);
                }
                this.configService.addRuntimeRegistry(registry);
                this.registries.add(registry);
            }
        }
    }

    public void destroy() throws PlatformException {
        for (AbstractRuntimeRegistry registry : this.registries) {
            try {
                registry.shutdown();
            }
            catch (Exception e) {
                LOGGER.warn("Error shutting down registry: " + registry.getClass().getName());
            }
        }
        for (ServerContainerConfigInfo runtimeConfigInfo : this.runtimeConfigInfoList) {
            runtimeConfigInfo.getRuntimeContext().close();
        }
        this.runtimeConfigInfoList = null;
    }

    public void reloadRuntime(ServerContainer runtime, Resource resource) {
        AbstractRuntimeRegistry registry = this.getRegistry(runtime.getComponentAdmin().getComponentName());
        registry.unregisterRuntime(runtime);
        LOGGER.debug("Unregistered ServerContainer: " + runtime.getComponentAdmin().getComponentName());
        this.loadComponent(resource);
        for (ServerContainerConfigInfo runtimeConfigInfo : this.runtimeConfigInfoList) {
            if (!runtimeConfigInfo.getXmlConfigFile().getAbsolutePath().equalsIgnoreCase(((FileSystemResource)resource).getFile().getAbsolutePath())) continue;
            LinkedList<ServerContainerConfigInfo> reloadRuntimeConfigInfoList = new LinkedList<ServerContainerConfigInfo>();
            reloadRuntimeConfigInfoList.add(runtimeConfigInfo);
            try {
                registry.init(reloadRuntimeConfigInfoList);
            }
            catch (Exception e) {
                LOGGER.error("Error updating registry : " + registry.getClass().getName() + " for runtime : " + runtime.getComponentAdmin().getComponentName(), (Throwable)e);
                throw new PlatformException("Error updating registry : " + registry.getClass().getName() + " for runtime : " + runtime.getComponentAdmin().getComponentName(), (Throwable)e);
            }
            return;
        }
    }

    public void loadComponent(Resource resource) {
        if (!FileSystemResource.class.isAssignableFrom(resource.getClass()) || !resource.getFilename().equalsIgnoreCase(this.getRuntimeConfigFileName())) {
            throw new UnsupportedOperationException("Runtimes can be loaded only from files by name : " + this.getRuntimeConfigFileName() + ". Specified resource is : " + resource.toString());
        }
        this.loadRuntimeContext(new ServerContainerConfigInfo(((FileSystemResource)resource).getFile()));
    }

    public void publishBootstrapEvent(PlatformEvent bootstrapEvent) {
        this.publishEvent(bootstrapEvent);
    }

    public void publishEvent(PlatformEvent event) {
        PlatformEventProducer publisher = (PlatformEventProducer)commonRuntimeBeansContext.getBean(DEFAULT_EVENT_PRODUCER);
        publisher.publishEvent(event);
    }

    public AbstractRuntimeRegistry getRegistry(String runtimeName) {
        for (AbstractRuntimeRegistry registry : this.registries) {
            if (registry.getRuntime(runtimeName) == null) continue;
            return registry;
        }
        throw new UnsupportedOperationException("No known registries exist for ServerContainer by name : " + runtimeName);
    }

    public abstract String getRuntimeConfigFileName();

    public abstract String getRuntimeModuleName();

    private void loadRuntimeContext(ServerContainerConfigInfo serverContainerConfigInfo) {
        for (ServerContainerConfigInfo loadedRuntimeConfigInfo : this.runtimeConfigInfoList) {
            if (!loadedRuntimeConfigInfo.equals(serverContainerConfigInfo)) continue;
            serverContainerConfigInfo = loadedRuntimeConfigInfo;
            break;
        }
        if (serverContainerConfigInfo.getRuntimeContext() != null) {
            serverContainerConfigInfo.getRuntimeContext().close();
            this.runtimeConfigInfoList.remove(serverContainerConfigInfo);
        }
        ClassLoader runtimeCL = this.tccl;
        File customLibPath = new File(serverContainerConfigInfo.getXmlConfigFile().getParentFile(), "lib");
        if (customLibPath.exists() && customLibPath.isDirectory()) {
            try {
                File[] libFiles = customLibPath.listFiles();
                URL[] libURLs = new URL[libFiles.length];
                for (int i = 0; i < libFiles.length; ++i) {
                    libURLs[i] = new URL("file:" + libFiles[i].getAbsolutePath());
                }
                runtimeCL = new URLClassLoader(libURLs, this.tccl);
            }
            catch (MalformedURLException e) {
                throw new PlatformException((Throwable)e);
            }
        }
        serverContainerConfigInfo.loadRuntimeContext(runtimeCL, RuntimeComponentContainer.getCommonRuntimeBeansContext());
        this.runtimeConfigInfoList.add(serverContainerConfigInfo);
    }
}

