/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.serializer.stateengine;

import com.flipkart.aesop.serializer.SerializerConstants;
import com.flipkart.aesop.serializer.stateengine.StateTransitioner;
import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.io.FastBlobWriter;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Calendar;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class DailyStateTransitioner<T>
extends StateTransitioner<T> {
    private static final Logger LOGGER = LogFactory.getLogger(DailyStateTransitioner.class);
    private FastBlobStateEngine stateEngine;

    @Override
    public FastBlobStateEngine getStateEngine() {
        return this.stateEngine;
    }

    @Override
    public void saveState() {
        this.getStateEngine().prepareForWrite();
        FastBlobWriter writer = new FastBlobWriter(this.getStateEngine());
        DataOutputStream dataOS = null;
        try {
            Calendar calendar = Calendar.getInstance();
            File dayDir = new File(this.serializedDataLocationDir, SerializerConstants.DAILY_DIR_FORMAT.format(calendar.getTime()));
            if (!dayDir.exists() || this.stateEngine.getLatestVersion() == null || this.stateEngine.getLatestVersion().trim().length() == 0) {
                dayDir.mkdir();
                File snapshotFile = new File(dayDir, String.valueOf(SerializerConstants.DAILY_FILE_FORMAT.format(calendar.getTime())) + "_" + "snapshot");
                snapshotFile.createNewFile();
                dataOS = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(snapshotFile)));
                writer.writeSnapshot(dataOS);
                LOGGER.info("Fast blob state engine data written to snapshot file : " + snapshotFile.getAbsolutePath());
            } else {
                File deltaFile = new File(dayDir, String.valueOf(SerializerConstants.DAILY_FILE_FORMAT.format(calendar.getTime())) + "_" + "delta");
                deltaFile.createNewFile();
                dataOS = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(deltaFile)));
                writer.writeDelta(dataOS);
                LOGGER.info("Fast blob state engine data written to delta file : " + deltaFile.getAbsolutePath());
            }
            dataOS.close();
            this.stateEngine.setLatestVersion(SerializerConstants.DAILY_FILE_FORMAT.format(calendar.getTime()));
            this.getStateEngine().prepareForNextCycle();
        }
        catch (Exception e) {
            throw new PlatformException("Error saving state engine data : " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.stateEngine = new FastBlobStateEngine(this.serializerFactory);
    }
}

