/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.spring.web;

import com.flipkart.aesop.runtime.config.ProducerRegistration;
import com.flipkart.aesop.runtime.impl.registry.ServerContainerRegistry;
import com.flipkart.aesop.runtime.relay.DefaultRelay;
import com.flipkart.aesop.runtime.spi.admin.RuntimeConfigService;
import com.flipkart.aesop.runtime.spring.web.RelayInfo;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.relay.config.LogicalSourceConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RelayController {
    private static final int MAX_CONNECTIONS = 5;
    private static Logger logger = LoggerFactory.getLogger(RelayController.class);
    private ServerContainerRegistry runtimeRegistry;
    private RuntimeConfigService configService;
    private ObjectMapper mapper = new ObjectMapper();
    private static AtomicInteger concurrentConnections = new AtomicInteger(0);

    @RequestMapping(value={"/relays", "/"}, method={RequestMethod.GET})
    public String relays(ModelMap model, HttpServletRequest request) {
        LinkedList<RelayInfo> relayInfos = new LinkedList<RelayInfo>();
        for (ServerContainer serverContainer : this.runtimeRegistry.getRuntimes()) {
            if (!DefaultRelay.class.isAssignableFrom(serverContainer.getClass())) continue;
            DefaultRelay relay = (DefaultRelay)serverContainer;
            for (ProducerRegistration producerRegistration : relay.getProducerRegistrationList()) {
                RelayInfo relayInfo = new RelayInfo(producerRegistration.getPhysicalSourceConfig().getId(), producerRegistration.getPhysicalSourceConfig().getName(), producerRegistration.getPhysicalSourceConfig().getUri());
                RelayInfo.LSourceInfo[] lSourceInfos = this.getLogicalSourceForProducer(producerRegistration.getPhysicalSourceConfig().getSources());
                relayInfo.setlSourceInfos(lSourceInfos);
                relayInfo.setProducerName(producerRegistration.getEventProducer().getName());
                relayInfo.setProducerSinceSCN(String.valueOf(producerRegistration.getEventProducer().getSCN()));
                List<String> peers = relay.getPeers();
                RelayInfo.ClientInfo[] clientInfos = new RelayInfo.ClientInfo[peers.size()];
                int i = 0;
                while (i < clientInfos.length) {
                    clientInfos[i] = new RelayInfo.ClientInfo(peers.get(i));
                    clientInfos[i].setClientSinceSCN(relay.getHttpStatisticsCollector().getPeerStats(peers.get(i)).getMaxStreamWinScn());
                    ++i;
                }
                relayInfo.setClientInfos(clientInfos);
                relayInfo.setHostGroupedClient();
                relayInfos.add(relayInfo);
            }
        }
        model.addAttribute("relayInfos", (Object)relayInfos.toArray(new RelayInfo[0]));
        if (request.getServletPath().endsWith(".json")) {
            return "relays-json";
        }
        JSONObject relayClientGrouped = this.getRelayClientGroupedJson(relayInfos);
        model.addAttribute("relayClientGrouped", (Object)relayClientGrouped.toString());
        return "relays";
    }

    @RequestMapping(value={"/metrics"}, method={RequestMethod.GET})
    public String metrics() {
        return "metrics";
    }

    /*
     * Loose catch block
     */
    @RequestMapping(value={"/metrics-stream"}, method={RequestMethod.GET})
    @ResponseBody
    public void metricsStream(HttpServletRequest request, HttpServletResponse response) {
        try {
            try {
                if (concurrentConnections.incrementAndGet() > 5) {
                    logger.info("Client refused due to max concurrency reached");
                    response.sendError(503, "Max concurrent connections reached: 5");
                } else {
                    DefaultRelay relay = null;
                    for (ServerContainer serverContainer : this.runtimeRegistry.getRuntimes()) {
                        if (!DefaultRelay.class.isAssignableFrom(serverContainer.getClass())) continue;
                        relay = (DefaultRelay)serverContainer;
                        break;
                    }
                    if (relay != null) {
                        logger.info("Client connected: " + request.getSession().getId());
                        response.setHeader("Content-Type", "text/event-stream;charset=UTF-8");
                        response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
                        response.setHeader("Pragma", "no-cache");
                        while (true) {
                            response.getWriter().println("data: " + relay.getMetricsCollector().getJson() + "\n");
                            response.flushBuffer();
                            Thread.sleep(relay.getMetricsCollector().getRefreshInterval() * 1000);
                        }
                    }
                    logger.info("Relay not found!");
                    response.sendError(404, "Relay not found!");
                }
            }
            catch (IOException e) {
                logger.info("Client Disconnected: " + request.getSession().getId());
                concurrentConnections.decrementAndGet();
            }
            catch (InterruptedException e) {
                logger.info("Client Disconnected: " + request.getSession().getId() + " (Interrupted)");
                Thread.currentThread().interrupt();
                concurrentConnections.decrementAndGet();
            }
            catch (Exception e) {
                logger.error("Client Disconnected: " + request.getSession().getId() + " (Unknown Exception)", (Throwable)e);
                concurrentConnections.decrementAndGet();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            concurrentConnections.decrementAndGet();
        }
    }

    @RequestMapping(value={"/metrics-json"}, method={RequestMethod.GET})
    @ResponseBody
    public void metricsJSON(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setHeader("Content-Type", "application/json");
            response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            DefaultRelay relay = null;
            for (ServerContainer serverContainer : this.runtimeRegistry.getRuntimes()) {
                if (!DefaultRelay.class.isAssignableFrom(serverContainer.getClass())) continue;
                relay = (DefaultRelay)serverContainer;
                break;
            }
            if (relay != null) {
                if (request.getParameterMap().containsKey("full")) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("inbound", relay.getInboundEventStatisticsCollector());
                    map.put("outbound", relay.getOutboundEventStatisticsCollector());
                    map.put("http", relay.getHttpStatisticsCollector());
                    response.getWriter().print(this.mapper.writeValueAsString(map));
                } else {
                    response.getWriter().print(relay.getMetricsCollector().getJson());
                }
            } else {
                response.getWriter().println("{}");
            }
            response.flushBuffer();
        }
        catch (IOException e) {
            logger.info("Client Disconnected: " + request.getSession().getId());
        }
        catch (Exception e) {
            logger.error("Client Disconnected: " + request.getSession().getId() + " (Unknown Exception)", (Throwable)e);
        }
    }

    public ServerContainerRegistry getRuntimeRegistry() {
        return this.runtimeRegistry;
    }

    public void setRuntimeRegistry(ServerContainerRegistry runtimeRegistry) {
        this.runtimeRegistry = runtimeRegistry;
    }

    public RuntimeConfigService getConfigService() {
        return this.configService;
    }

    public void setConfigService(RuntimeConfigService configService) {
        this.configService = configService;
    }

    private JSONObject getRelayClientGroupedJson(List<RelayInfo> relayInfoList) {
        HashMap relayClientGrouped = new HashMap();
        for (RelayInfo relay : relayInfoList) {
            RelayInfo.ClientInfo[] clientInfos;
            HashMap relayClientInfo = (HashMap)relayClientGrouped.get(relay.getpSourceId());
            if (relayClientInfo == null) {
                relayClientInfo = new HashMap();
            }
            RelayInfo.ClientInfo[] clientInfoArray = clientInfos = relay.getClientInfos();
            int n = clientInfos.length;
            int n2 = 0;
            while (n2 < n) {
                RelayInfo.ClientInfo clientInfo = clientInfoArray[n2];
                String hostName = clientInfo.getClientHost();
                if (relayClientInfo.get(hostName) == null) {
                    relayClientInfo.put(hostName, new HashMap());
                }
                ((Map)relayClientInfo.get(hostName)).put(clientInfo.getClientName(), clientInfo.getClientSinceSCN());
                ++n2;
            }
            relayClientGrouped.put(relay.getpSourceId(), relayClientInfo);
        }
        return new JSONObject(relayClientGrouped);
    }

    private RelayInfo.LSourceInfo[] getLogicalSourceForProducer(List<LogicalSourceConfig> lSources) {
        RelayInfo.LSourceInfo[] lSourceInfos = new RelayInfo.LSourceInfo[lSources.size()];
        int i = 0;
        while (i < lSourceInfos.length) {
            lSourceInfos[i] = new RelayInfo.LSourceInfo(lSources.get(i).getId());
            lSourceInfos[i].setLSourceName(lSources.get(i).getName());
            lSourceInfos[i].setLSourceURI(lSources.get(i).getUri());
            ++i;
        }
        return lSourceInfos;
    }
}

