/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.producer.impl;

import com.flipkart.aesop.runtime.producer.spi.SCNGenerator;
import com.linkedin.databus.client.pub.CheckpointPersistenceProvider;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusClientMode;
import java.io.IOException;
import java.util.Arrays;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class GenerationalSCNGenerator
implements SCNGenerator,
InitializingBean {
    private static final Logger LOGGER = LogFactory.getLogger(GenerationalSCNGenerator.class);
    private static final int NO_GENERATION = -1;
    private static final String NO_HOST = "";
    private int currentGeneration = -1;
    private String currentHostId = "";
    private CheckpointPersistenceProvider checkpointPersistenceProvider;
    private String relayLogicalSourceName;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.relayLogicalSourceName, (String)"'relayLogicalSourceName' cannot be null. This SCN generator will not be initialized");
        Assert.notNull((Object)this.checkpointPersistenceProvider, (String)"'checkpointPersistenceProvider' cannot be null. This SCN generator will not be initialized");
        Checkpoint cp = this.checkpointPersistenceProvider.loadCheckpoint(Arrays.asList(this.relayLogicalSourceName));
        if (cp != null) {
            this.currentGeneration = cp.getBootstrapSinceScn().intValue();
            this.currentHostId = cp.getBootstrapServerInfo();
        }
    }

    @Override
    public long getSCN(long localSCN, String hostId) {
        if (!hostId.equalsIgnoreCase(this.currentHostId) || this.currentGeneration == -1) {
            this.currentHostId = hostId;
            ++this.currentGeneration;
            Checkpoint cp = new Checkpoint();
            cp.setConsumptionMode(DbusClientMode.BOOTSTRAP_SNAPSHOT);
            cp.setBootstrapSinceScn(Long.valueOf(this.currentGeneration));
            cp.setBootstrapServerInfo(this.currentHostId);
            cp.setTsNsecs(System.nanoTime());
            try {
                this.checkpointPersistenceProvider.storeCheckpoint(Arrays.asList(this.relayLogicalSourceName), cp);
            }
            catch (IOException e) {
                LOGGER.error("Get SCN failed. Error storing checkpoint for : " + this.relayLogicalSourceName, (Throwable)e);
                throw new DatabusRuntimeException("Get SCN failed. Error storing checkpoint for : " + this.relayLogicalSourceName, (Throwable)e);
            }
        }
        long fileId = localSCN >> 32;
        long mask = Integer.MAX_VALUE;
        long offset = localSCN & mask;
        long scn = this.currentGeneration;
        scn <<= 8;
        scn |= fileId;
        scn <<= 24;
        return scn |= offset;
    }

    public CheckpointPersistenceProvider getCheckpointPersistenceProvider() {
        return this.checkpointPersistenceProvider;
    }

    public void setCheckpointPersistenceProvider(CheckpointPersistenceProvider checkpointPersistenceProvider) {
        this.checkpointPersistenceProvider = checkpointPersistenceProvider;
    }
}

