/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.relay.netty;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus2.core.container.monitoring.mbean.HttpStatisticsCollector;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import java.net.InetSocketAddress;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class RelayStatisticsCollectingHandler
extends SimpleChannelHandler {
    protected static final Logger LOGGER = LogFactory.getLogger(RelayStatisticsCollectingHandler.class);
    private DbusEventsStatisticsCollector outEventStatsCollector;
    private DbusEventsStatisticsCollector connOutEventStatsCollector;
    private HttpStatisticsCollector outHttpStatsCollector;
    private HttpStatisticsCollector connOutHttpStatsCollector;
    private DatabusRequest latestDbusRequest = null;

    public RelayStatisticsCollectingHandler(HttpRelay relay) {
        this.outEventStatsCollector = relay.getOutboundEventStatisticsCollector();
        this.outHttpStatsCollector = relay.getHttpStatisticsCollector();
        this.connOutEventStatsCollector = null;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.outEventStatsCollector != null || this.outHttpStatsCollector != null) {
            InetSocketAddress inetAddress;
            Object value = e.getValue();
            String client = null;
            client = value instanceof InetSocketAddress ? ((inetAddress = (InetSocketAddress)value).getAddress().isLoopbackAddress() ? "localhost" : inetAddress.getAddress().getHostAddress()) : e.getValue().toString();
            if (this.outEventStatsCollector != null) {
                this.connOutEventStatsCollector = this.outEventStatsCollector.createForPeerConnection(client);
            }
            if (this.outHttpStatsCollector != null) {
                this.connOutHttpStatsCollector = this.outHttpStatsCollector.createForClientConnection(client);
            }
        }
        super.channelConnected(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        try {
            if (this.outEventStatsCollector != null || this.outHttpStatsCollector != null) {
                if (e.getMessage() instanceof DatabusRequest) {
                    this.latestDbusRequest = (DatabusRequest)e.getMessage();
                    if (this.outEventStatsCollector != null) {
                        this.latestDbusRequest.getParams().put(this.outEventStatsCollector.getName(), this.connOutEventStatsCollector);
                    }
                    if (this.outHttpStatsCollector != null) {
                        this.latestDbusRequest.getParams().put(this.outHttpStatsCollector.getName(), this.connOutHttpStatsCollector);
                    }
                    if (this.latestDbusRequest.getParams().getProperty("checkPoint") != null) {
                        Checkpoint cp = new Checkpoint(this.latestDbusRequest.getParams().getProperty("checkPoint"));
                        String peer = (String)this.connOutHttpStatsCollector.getPeers().get(0);
                        this.connOutHttpStatsCollector.getPeerStats(peer).registerStreamRequest(peer, cp);
                    }
                } else if (this.shouldMerge(e)) {
                    this.mergePerConnStats();
                }
            }
            super.messageReceived(ctx, e);
        }
        catch (Exception ex) {
            LOGGER.error("Exception while processing message in RelayStatisticsCollectingHandler");
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.connOutEventStatsCollector != null || this.connOutHttpStatsCollector != null) {
            this.mergePerConnStats();
            if (this.connOutEventStatsCollector != null) {
                this.connOutEventStatsCollector.unregisterMBeans();
            }
            if (this.connOutHttpStatsCollector != null) {
                this.connOutHttpStatsCollector.unregisterMBeans();
            }
            this.connOutEventStatsCollector = null;
            this.connOutHttpStatsCollector = null;
        }
        this.latestDbusRequest = null;
        super.channelClosed(ctx, e);
    }

    private boolean shouldMerge(MessageEvent me) {
        return me.getMessage() instanceof HttpChunkTrailer || me.getMessage() instanceof HttpResponse;
    }

    private void mergePerConnStats() {
        if (this.connOutEventStatsCollector != null) {
            this.outEventStatsCollector.merge(this.connOutEventStatsCollector);
            this.connOutEventStatsCollector.reset();
        }
        if (this.connOutHttpStatsCollector != null) {
            this.outHttpStatsCollector.merge(this.connOutHttpStatsCollector);
            this.connOutHttpStatsCollector.reset();
        }
    }
}

