/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.spring.web;

import com.flipkart.aesop.runtime.config.ProducerRegistration;
import com.flipkart.aesop.runtime.impl.registry.ServerContainerRegistry;
import com.flipkart.aesop.runtime.relay.DefaultRelay;
import com.flipkart.aesop.runtime.spi.admin.RuntimeConfigService;
import com.flipkart.aesop.runtime.spring.web.RelayInfo;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.relay.config.LogicalSourceConfig;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class RelayController {
    private ServerContainerRegistry runtimeRegistry;
    private RuntimeConfigService configService;

    @RequestMapping(value={"/relays", "/"}, method={RequestMethod.GET})
    public String relays(ModelMap model, HttpServletRequest request) {
        LinkedList<RelayInfo> relayInfos = new LinkedList<RelayInfo>();
        for (ServerContainer serverContainer : this.runtimeRegistry.getRuntimes()) {
            if (!DefaultRelay.class.isAssignableFrom(serverContainer.getClass())) continue;
            DefaultRelay relay = (DefaultRelay)serverContainer;
            for (ProducerRegistration producerRegistration : relay.getProducerRegistrationList()) {
                RelayInfo relayInfo = new RelayInfo(producerRegistration.getPhysicalSourceConfig().getId(), producerRegistration.getPhysicalSourceConfig().getName(), producerRegistration.getPhysicalSourceConfig().getUri());
                if (producerRegistration.getPhysicalSourceConfig().getSources().size() > 0) {
                    relayInfo.setlSourceId(((LogicalSourceConfig)producerRegistration.getPhysicalSourceConfig().getSources().get(0)).getId());
                    relayInfo.setlSourceName(((LogicalSourceConfig)producerRegistration.getPhysicalSourceConfig().getSources().get(0)).getName());
                    relayInfo.setlSourceURI(((LogicalSourceConfig)producerRegistration.getPhysicalSourceConfig().getSources().get(0)).getUri());
                }
                relayInfo.setProducerName(producerRegistration.getEventProducer().getName());
                relayInfo.setProducerSinceSCN(String.valueOf(producerRegistration.getEventProducer().getSCN()));
                List peers = relay.getHttpStatisticsCollector().getPeers();
                RelayInfo.ClientInfo[] clientInfos = new RelayInfo.ClientInfo[peers.size()];
                for (int i = 0; i < clientInfos.length; ++i) {
                    clientInfos[i] = new RelayInfo.ClientInfo((String)peers.get(i));
                    clientInfos[i].setClientSinceSCN(String.valueOf(relay.getHttpStatisticsCollector().getPeerStats((String)peers.get(i)).getMaxStreamWinScn()));
                }
                relayInfo.setClientInfos(clientInfos);
                relayInfos.add(relayInfo);
            }
        }
        model.addAttribute("relayInfos", (Object)relayInfos.toArray(new RelayInfo[0]));
        if (request.getServletPath().endsWith(".json")) {
            return "relays-json";
        }
        return "relays";
    }

    public ServerContainerRegistry getRuntimeRegistry() {
        return this.runtimeRegistry;
    }

    public void setRuntimeRegistry(ServerContainerRegistry runtimeRegistry) {
        this.runtimeRegistry = runtimeRegistry;
    }

    public RuntimeConfigService getConfigService() {
        return this.configService;
    }

    public void setConfigService(RuntimeConfigService configService) {
        this.configService = configService;
    }
}

