/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.client;

import com.flipkart.aesop.runtime.client.DefaultClient;
import com.flipkart.aesop.runtime.config.ClientConfig;
import com.flipkart.aesop.runtime.config.ConsumerRegistration;
import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.pub.DatabusBootstrapConsumer;
import com.linkedin.databus.client.pub.DatabusStreamConsumer;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultClientFactory
implements FactoryBean<DefaultClient>,
InitializingBean {
    private ClientConfig clientConfig;
    private List<ConsumerRegistration> consumerRegistrationList = new ArrayList<ConsumerRegistration>();

    public DefaultClient getObject() throws Exception {
        DatabusHttpClientImpl.Config config = new DatabusHttpClientImpl.Config();
        ConfigLoader staticConfigLoader = new ConfigLoader(this.clientConfig.getClientPropertiesPrefix(), (ConfigBuilder)config);
        DatabusHttpClientImpl.StaticConfig staticConfig = (DatabusHttpClientImpl.StaticConfig)staticConfigLoader.loadConfig((Map)this.clientConfig.getClientProperties());
        DefaultClient defaultClient = new DefaultClient(staticConfig);
        for (ConsumerRegistration consumerRegistration : this.consumerRegistrationList) {
            defaultClient.registerDatabusStreamListener((DatabusStreamConsumer)consumerRegistration.getEventConsumer(), null, consumerRegistration.getLogicalSources().toArray(new String[0]));
            if (!consumerRegistration.isReadFromBootstrap()) continue;
            defaultClient.registerDatabusBootstrapListener((DatabusBootstrapConsumer)consumerRegistration.getEventConsumer(), null, consumerRegistration.getLogicalSources().toArray(new String[0]));
        }
        return defaultClient;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.clientConfig, (String)"'clientConfig' cannot be null. This Relay Client will not be initialized");
        Assert.notEmpty(this.consumerRegistrationList, (String)"'consumerRegistrationList' cannot be empty. No Event consumers registered");
    }

    public Class<DefaultClient> getObjectType() {
        return DefaultClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public List<ConsumerRegistration> getConsumerRegistrationList() {
        return this.consumerRegistrationList;
    }

    public void setConsumerRegistrationList(List<ConsumerRegistration> consumerRegistrationList) {
        this.consumerRegistrationList = consumerRegistrationList;
    }
}

