/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.clusterclient;

import com.linkedin.databus.client.pub.DatabusClientException;
import com.linkedin.databus.client.pub.DatabusRegistration;
import com.linkedin.databus.client.pub.DbusPartitionInfo;
import com.linkedin.databus.client.pub.DbusPartitionListener;
import com.linkedin.databus.client.pub.RegistrationId;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class DefaultPartitionListener
implements DbusPartitionListener {
    private static final Logger logger = LogFactory.getLogger(DefaultPartitionListener.class);

    public void onAddPartition(DbusPartitionInfo partitionInfo, DatabusRegistration reg) {
        logger.info("New partition is getting added. Partition Id = " + partitionInfo.getPartitionId());
        try {
            reg.withRegId(new RegistrationId("ClusterId_" + partitionInfo.getPartitionId()));
        }
        catch (IllegalStateException e) {
            logger.error("Exception when adding partition", (Throwable)e);
        }
        catch (DatabusClientException e) {
            logger.error("Exception when adding partition", (Throwable)e);
        }
    }

    public void onDropPartition(DbusPartitionInfo partitionInfo, DatabusRegistration reg) {
        logger.info("Partition is getting dropped. Partition Id = " + partitionInfo.getPartitionId());
    }
}

