/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.bootstrap.consumer;

import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.eventconsumer.AbstractEventConsumer;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus2.core.BackoffTimer;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class SourceEventProcessor
implements Runnable {
    public static final Logger LOGGER = LogFactory.getLogger(SourceEventProcessor.class);
    private final AbstractEvent sourceEvent;
    private final AbstractEventConsumer consumer;
    private final BackoffTimer timer;

    public SourceEventProcessor(AbstractEvent sourceEvent, AbstractEventConsumer consumer, BackoffTimer timer) {
        this.sourceEvent = sourceEvent;
        this.consumer = consumer;
        this.timer = timer;
    }

    @Override
    public void run() {
        LOGGER.info("Processing :" + this.sourceEvent.getPrimaryKeyValues() + ":" + this.sourceEvent.getNamespaceName() + "" + this.sourceEvent.getEntityName());
        this.process();
    }

    private void process() {
        try {
            ConsumerCallbackResult consumerCallbackResult = this.consumer.processSourceEvent(this.sourceEvent);
            switch (consumerCallbackResult) {
                case ERROR: {
                    this.timer.backoffAndSleep();
                    this.process();
                    break;
                }
                case SUCCESS: 
                case SKIP_CHECKPOINT: {
                    break;
                }
                case ERROR_FATAL: {
                    throw new RuntimeException("Fatal Failure for Source Event : " + this.sourceEvent);
                }
            }
            LOGGER.info(consumerCallbackResult.toString());
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while processing event " + e.getMessage(), (Throwable)e);
            this.timer.backoffAndSleep();
            this.process();
        }
    }
}

