/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.mysqldatalayer.upsert;

import com.flipkart.aesop.destinationoperation.JDBCDataLayer;
import com.flipkart.aesop.destinationoperation.UpsertDestinationStoreProcessor;
import com.flipkart.aesop.event.AbstractEvent;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class MySQLUpsertDataLayer
extends UpsertDestinationStoreProcessor
implements JDBCDataLayer {
    private Map<String, NamedParameterJdbcTemplate> jdbcTemplateMap;

    public MySQLUpsertDataLayer(Map<String, NamedParameterJdbcTemplate> jdbcTemplateMap) {
        this.jdbcTemplateMap = jdbcTemplateMap;
    }

    public Map<String, NamedParameterJdbcTemplate> getJdbcTemplateMap() {
        return this.jdbcTemplateMap;
    }

    protected void upsert(AbstractEvent event) {
        String upsertQuery = this.generateUpsertQuery(event);
        NamedParameterJdbcTemplate jdbcTemplate = this.jdbcTemplateMap.get(event.getNamespaceName());
        jdbcTemplate.update(upsertQuery, event.getFieldMapPair());
    }

    private String generateUpsertQuery(AbstractEvent event) {
        StringBuilder columnNameStringBuilder = new StringBuilder();
        StringBuilder columnValueStringBuilder = new StringBuilder();
        StringBuilder updateQueryStringBuilder = new StringBuilder();
        this.populateUpsertQueryParts(event.getFieldMapPair(), event.getPrimaryKeySet(), columnNameStringBuilder, columnValueStringBuilder, updateQueryStringBuilder);
        return this.buildQuery(event.getNamespaceName(), event.getEntityName(), columnNameStringBuilder, columnValueStringBuilder, updateQueryStringBuilder);
    }

    private void populateUpsertQueryParts(Map<String, Object> fieldMap, Set<String> primaryKeySet, StringBuilder columnNameStringBuilder, StringBuilder columnValueStringBuilder, StringBuilder updateQueryStringBuilder) {
        for (String field : fieldMap.keySet()) {
            columnNameStringBuilder.append(String.valueOf(field) + ",");
            columnValueStringBuilder.append(":" + field + ",");
            if (primaryKeySet.contains(field)) continue;
            updateQueryStringBuilder.append(String.valueOf(field) + "=:" + field + ",");
        }
    }

    private String buildQuery(String namespace, String entity, StringBuilder columnNameStringBuilder, StringBuilder columnValueStringBuilder, StringBuilder updateQueryStringBuilder) {
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append(String.valueOf(namespace) + "." + entity + " (");
        query.append(columnNameStringBuilder.substring(0, columnNameStringBuilder.length() - 1));
        query.append(") VALUES(");
        query.append(columnValueStringBuilder.substring(0, columnValueStringBuilder.length() - 1));
        query.append(")  ON DUPLICATE KEY UPDATE ");
        query.append(updateQueryStringBuilder.substring(0, updateQueryStringBuilder.length() - 1));
        return query.toString();
    }
}

