/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.processor.kafka.producer.codec;

import com.flipkart.aesop.processor.kafka.producer.codec.ifaces.Codec;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.validation.constraints.NotNull;
import org.apache.kafka.common.errors.SerializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringCodec
implements Codec<String> {
    private String encoding = "UTF8";

    @Override
    public byte[] encode(@NotNull String data) throws IOException {
        try {
            return data.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("Error when serializing string to byte[] due to unsupported encoding " + this.encoding);
        }
    }

    @Override
    public String decode(byte[] bytes) throws IOException {
        return new String(bytes, this.encoding);
    }
}

