/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.processor.kafka.preprocessor;

import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.processor.kafka.client.KafkaClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.util.SerializationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KafkaEventDefaultPreprocessor {
    private KafkaClient kafkaClient;
    private static final String KEY = "KEY";
    private static final String FIELD_MAP = "FIELD_MAP";
    private static final String ENTITY = "ENTITY";
    private static final String NAMESPACE = "NAMESPACE";
    private static final String OPCODE = "OPCODE";

    public ProducerRecord createProducerRecord(AbstractEvent event) {
        return new ProducerRecord(this.kafkaClient.getTopic(event.getNamespaceName()), this.getPrimaryKey(event), (Object)SerializationUtils.serialize(this.getPayload(event)));
    }

    private Object getPrimaryKey(AbstractEvent event) {
        if (event.getPrimaryKeyValues() != null && event.getPrimaryKeyValues().size() > 0) {
            return event.getPrimaryKeyValues().get(0);
        }
        return null;
    }

    private Map<String, Object> getPayload(AbstractEvent event) {
        Object key = this.getPrimaryKey(event);
        Map fieldMap = event.getFieldMapPair();
        String entityName = event.getEntityName();
        String nameSpaceName = event.getNamespaceName();
        String opCode = event.getEventType().name();
        HashMap<String, Object> payload = new HashMap<String, Object>();
        this.mapput(payload, KEY, key);
        this.mapput(payload, FIELD_MAP, fieldMap);
        this.mapput(payload, ENTITY, entityName);
        this.mapput(payload, NAMESPACE, nameSpaceName);
        this.mapput(payload, OPCODE, opCode);
        return payload;
    }

    private void mapput(Map<String, Object> map, String key, Object value) {
        if (key != null && value != null) {
            map.put(key, value);
        }
    }

    public void setKafkaClient(KafkaClient kafkaClient) {
        this.kafkaClient = kafkaClient;
    }

    public KafkaClient getKafkaClient() {
        return this.kafkaClient;
    }
}

