/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.hbasedatalayer;

import com.flipkart.aesop.destinationoperation.JDBCDataLayer;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHBaseDataLayerFactory<T extends JDBCDataLayer>
implements FactoryBean<T> {
    private Properties dataSourceProperties;
    private String driverClass;
    private String jdbcUrl;
    private String dataSourceName;
    private Map<String, NamedParameterJdbcTemplate> jdbcTemplateMap;
    public static final Logger LOGGER = LogFactory.getLogger(AbstractHBaseDataLayerFactory.class);

    public abstract T createDestinationOperationHandler(Map<String, NamedParameterJdbcTemplate> var1);

    public T getObject() throws Exception {
        this.createJdbcTemplateMap();
        return this.createDestinationOperationHandler(this.jdbcTemplateMap);
    }

    public abstract Class<?> getObjectType();

    public boolean isSingleton() {
        return false;
    }

    private void createJdbcTemplateMap() {
        this.jdbcTemplateMap = new HashMap<String, NamedParameterJdbcTemplate>();
        DataSource dataSource = this.getDataSource();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
        this.jdbcTemplateMap.put(this.getDataSourceName(), namedParameterJdbcTemplate);
    }

    private DataSource getDataSource() {
        ComboPooledDataSource comboPooledDataSource = null;
        try {
            comboPooledDataSource = new ComboPooledDataSource();
            comboPooledDataSource.setDriverClass(this.getDriverClass());
            comboPooledDataSource.setJdbcUrl(this.getJdbcUrl());
            comboPooledDataSource.setProperties(this.getDataSourceProperties());
        }
        catch (PropertyVetoException e) {
            LOGGER.error(e.getMessage());
        }
        return comboPooledDataSource;
    }

    public Properties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public void setDataSourceProperties(Properties dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }
}

