/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.processor.es.upsert;

import com.flipkart.aesop.destinationoperation.UpsertDestinationStoreProcessor;
import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.processor.es.client.ElasticSearchClient;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class ElasticSearchPartialUpsertProcessor
extends UpsertDestinationStoreProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(ElasticSearchPartialUpsertProcessor.class);
    private ElasticSearchClient elasticSearchClient;

    protected ConsumerCallbackResult upsert(AbstractEvent event) {
        LOGGER.info("Received Partial Upsert Event : " + event);
        LOGGER.info("Field Map Pair : " + event.getFieldMapPair().toString());
        try {
            String docId = String.valueOf(event.getFieldMapPair().get("id"));
            IndexRequest indexReq = new IndexRequest(this.elasticSearchClient.getIndex(), this.elasticSearchClient.getType(), docId).source(event.getFieldMapPair());
            UpdateRequest updateReq = new UpdateRequest(this.elasticSearchClient.getIndex(), this.elasticSearchClient.getType(), docId).doc(event.getFieldMapPair()).upsert(indexReq);
            UpdateResponse response = (UpdateResponse)this.elasticSearchClient.getClient().update(updateReq).get();
            LOGGER.info("Created/Updated doc: " + response.getId() + " v: " + response.getVersion() + " isCreated: " + response.isCreated());
        }
        catch (Exception e) {
            LOGGER.info("Server Connection Lost/Create Error" + e);
            throw new RuntimeException("Create Failure");
        }
        return ConsumerCallbackResult.SUCCESS;
    }

    public void setElasticSearchClient(ElasticSearchClient elasticSearchClient) {
        this.elasticSearchClient = elasticSearchClient;
    }

    public ElasticSearchClient getElasticSearchClient() {
        return this.elasticSearchClient;
    }
}

