/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.processor.es.delete;

import com.flipkart.aesop.destinationoperation.DeleteDestinationStoreProcessor;
import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.processor.es.client.ElasticSearchClient;
import org.elasticsearch.action.get.GetResponse;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class ElasticSearchDeleteProcessor
extends DeleteDestinationStoreProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(ElasticSearchDeleteProcessor.class);
    private ElasticSearchClient elasticSearchClient;

    protected void delete(AbstractEvent event) {
        LOGGER.info("Received Delete Event. Event is " + event);
        LOGGER.info("Field Map Pair : " + event.getFieldMapPair().toString());
        String id = String.valueOf(event.getFieldMapPair().get("id"));
        this.elasticSearchClient.getClient().prepareDelete(this.elasticSearchClient.getIndex(), this.elasticSearchClient.getType(), id).execute().actionGet();
        try {
            GetResponse response = (GetResponse)this.elasticSearchClient.getClient().prepareGet(this.elasticSearchClient.getIndex(), this.elasticSearchClient.getType(), id).execute().get();
            if (!response.isSourceEmpty()) {
                LOGGER.info("Delete Error:" + response);
                throw new RuntimeException("Delete Failure");
            }
        }
        catch (Exception e) {
            LOGGER.info("Server Connection Lost/Delete Error" + e);
            throw new RuntimeException("Delete Failure");
        }
    }

    public void setElasticSearchClient(ElasticSearchClient elasticSearchClient) {
        this.elasticSearchClient = elasticSearchClient;
    }

    public ElasticSearchClient getElasticSearchClient() {
        return this.elasticSearchClient;
    }
}

