/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.elasticsearchdatalayer.elasticsearchclient;

import com.flipkart.aesop.elasticsearchdatalayer.elasticsearchclient.ElasticSearchClient;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class ElasticSearchUnicastClient
extends ElasticSearchClient {
    private static final Logger LOGGER = LogFactory.getLogger(ElasticSearchUnicastClient.class);

    void init() {
        String hostname;
        this.config = ConfigFactory.parseFile((File)new File(this.elasticSearchConfig.getConfig()));
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.info("Unknown HostException Thrown - UpsertDatalayer");
            throw new RuntimeException("FATAL Error: Unable To get Host Information");
        }
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.config.getString("cluster.name")).put("node.name", hostname.replace('.', '-')).put("network.host", hostname).put("node.data", false).put("node.local", false).put("discovery.zen.ping.multicast.enabled", false).put("discovery.zen.ping.unicast.hosts", this.config.getString("hosts")).put("network.host", hostname);
        Node node = NodeBuilder.nodeBuilder().clusterName(this.config.getString("cluster.name")).client(true).local(false).settings((Settings.Builder)settings).node();
        node.start();
        this.client = node.client();
    }
}

