/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.eventconsumer.implementation;

import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.event.EventFactory;
import com.flipkart.aesop.eventconsumer.AbstractEventConsumer;
import com.flipkart.aesop.mapper.Mapper;
import com.flipkart.aesop.processor.DestinationEventProcessor;
import com.flipkart.aesop.transformer.PostMappingTransformer;
import com.flipkart.aesop.transformer.PreMappingTransformer;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusOpcode;
import com.linkedin.databus2.core.DatabusException;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;

public class DefaultEventConsumerImpl
extends AbstractEventConsumer {
    private PreMappingTransformer preMappingTransformer;
    private PostMappingTransformer postMappingTransformer;

    private DefaultEventConsumerImpl(Builder builder) {
        this.mapper = builder.getMapper();
        this.sourceEventFactory = builder.getSourceEventFactory();
        this.destinationGroupSet = builder.getDestinationGroupSet();
        this.destinationProcessorMap = builder.getDestinationProcessorMap();
        this.totalDestinationGroups = builder.getTotalDestinationGroups();
        this.preMappingTransformer = builder.getPreMappingTransformer();
        this.postMappingTransformer = builder.getPostMappingTransformer();
    }

    public AbstractEvent decodeSourceEvent(DbusEvent dbusEvent, DbusEventDecoder eventDecoder) throws DatabusException {
        return this.sourceEventFactory.createEvent(dbusEvent, eventDecoder);
    }

    public ConsumerCallbackResult processSourceEvent(AbstractEvent sourceEvent) {
        AbstractEvent sourceEventAfterTransformation = this.preMappingTransformer == null ? sourceEvent : this.preMappingTransformer.transform(sourceEvent);
        List<AbstractEvent> destinationEventList = this.mapper.mapSourceEventToDestinationEvent(sourceEventAfterTransformation, this.destinationGroupSet, this.totalDestinationGroups);
        for (AbstractEvent destinationEvent : destinationEventList) {
            AbstractEvent destinationEventAfterTransformation = this.postMappingTransformer == null ? destinationEvent : this.postMappingTransformer.transform(destinationEvent);
            DestinationEventProcessor destinationEventProcessor = (DestinationEventProcessor)this.destinationProcessorMap.get(destinationEvent.getEventType());
            try {
                ConsumerCallbackResult result;
                if (destinationEventProcessor == null || !ConsumerCallbackResult.isFailure((ConsumerCallbackResult)(result = destinationEventProcessor.processDestinationEvent(destinationEventAfterTransformation)))) continue;
                return result;
            }
            catch (OperationNotSupportedException e) {
                LOGGER.error("Operation Not Supported Exception occured while executing Destination Store Operation.", (Throwable)e);
                return ConsumerCallbackResult.ERROR;
            }
        }
        return ConsumerCallbackResult.SUCCESS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends AbstractEventConsumer.Builder<DefaultEventConsumerImpl> {
        private PreMappingTransformer preMappingTransformer;
        private PostMappingTransformer postMappingTransformer;

        public Builder(EventFactory sourceEventFactory, Mapper mapper, Map<DbusOpcode, ? extends DestinationEventProcessor> destinationEventProcessorMap) {
            super(sourceEventFactory, mapper, destinationEventProcessorMap);
        }

        public PreMappingTransformer getPreMappingTransformer() {
            return this.preMappingTransformer;
        }

        public PostMappingTransformer getPostMappingTransformer() {
            return this.postMappingTransformer;
        }

        public Builder withPreMappingTransformer(PreMappingTransformer preMappingTransformer) {
            this.preMappingTransformer = preMappingTransformer;
            return this;
        }

        public Builder withPostMappingTransformer(PostMappingTransformer postMappingTransformer) {
            this.postMappingTransformer = postMappingTransformer;
            return this;
        }

        @Override
        public DefaultEventConsumerImpl build() {
            return new DefaultEventConsumerImpl(this);
        }
    }
}

