/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.mapper.implementation;

import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.mapper.AbstractMapper;
import com.flipkart.aesop.mapper.enums.EntityExistInConfig;
import com.flipkart.aesop.mapper.enums.NamespaceExistInConfig;
import com.flipkart.aesop.mapper.implementation.MapperType;
import com.flipkart.aesop.mapper.utils.MapperHelper;
import com.typesafe.config.Config;
import java.util.List;
import java.util.Set;
import org.springframework.util.Assert;

public class DefaultMapperImpl
extends AbstractMapper {
    private Config config;

    private void setBeansForMapperType() {
        for (MapperType mapperType : this.mapperTypeList) {
            mapperType.setMapperConfig(this.mapperConfig);
            mapperType.setEventGroupFinder(this.eventGroupFinder);
            mapperType.setDestinationEventFactory(this.destinationEventFactory);
        }
    }

    private MapperType chooseMapperBasedOnConfig(String namespacePath, String entityPath) {
        Boolean namespacePathExist = this.mapperConfig.checkIfPathExists(namespacePath, this.config);
        Boolean entityPathExist = this.mapperConfig.checkIfPathExists(entityPath, this.config);
        NamespaceExistInConfig namespaceExistInConfig = NamespaceExistInConfig.valueOf(String.valueOf(namespacePathExist).toUpperCase());
        EntityExistInConfig entityExistInConfig = EntityExistInConfig.valueOf(String.valueOf(entityPathExist).toUpperCase());
        this.setBeansForMapperType();
        for (MapperType mapperType : this.mapperTypeList) {
            if (mapperType.namespacePathExists != namespaceExistInConfig || mapperType.entityPathExists != entityExistInConfig) continue;
            return mapperType;
        }
        return null;
    }

    @Override
    public List<AbstractEvent> mapSourceEventToDestinationEvent(AbstractEvent sourceEvent, Set<Integer> destinationGroupSet, int totalDestinationGroups) {
        this.config = this.mapperConfig.getConfig(this.configFilePath);
        String namespacePath = MapperHelper.getNamespacePath(this.configRoot, sourceEvent);
        String entityPath = MapperHelper.getEntityPath(this.configRoot, sourceEvent);
        MapperType mapperType = this.chooseMapperBasedOnConfig(namespacePath, entityPath);
        Assert.notNull((Object)((Object)mapperType));
        return mapperType.map(this.config, this.configRoot, sourceEvent, destinationGroupSet, totalDestinationGroups);
    }
}

