/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.mapper.eventGroupFilter;

import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.mapper.eventGroupFilter.EventGroupFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractEventGroupFinder
implements EventGroupFinder {
    public String namespaceEntitySeparator = "__";
    public Integer defaultGroup = 1;

    @Override
    public List<AbstractEvent> filterEventsByGroup(List<AbstractEvent> eventList, Integer destinationGroupNo, Integer totalDestinationGroups) {
        ArrayList<AbstractEvent> filteredEventList = new ArrayList<AbstractEvent>();
        for (AbstractEvent abstractEvent : eventList) {
            String namespaceEntity = String.valueOf(abstractEvent.getNamespaceName()) + this.namespaceEntitySeparator + abstractEvent.getEntityName();
            if (this.getEventGroupNo(namespaceEntity, totalDestinationGroups) != destinationGroupNo) continue;
            filteredEventList.add(abstractEvent);
        }
        return filteredEventList;
    }

    @Override
    public AbstractEvent filterEventByGroup(AbstractEvent event, Integer destinationGroupNo, Integer totalDestinationGroups) {
        List<AbstractEvent> filteredEvent = this.filterEventsByGroup(Arrays.asList(event), destinationGroupNo, totalDestinationGroups);
        if (filteredEvent == null || filteredEvent.size() == 0) {
            return null;
        }
        return filteredEvent.get(0);
    }

    @Override
    public abstract Integer getEventGroupNo(String var1, Integer var2);

    @Override
    public Integer getEventGroupNo(String namespace, String entity, Integer totalDestinationGroups) {
        String namespaceEntity = String.valueOf(namespace) + this.namespaceEntitySeparator + entity;
        return this.getEventGroupNo(namespaceEntity, totalDestinationGroups);
    }
}

