/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.eventconsumer;

import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.event.EventFactory;
import com.flipkart.aesop.mapper.Mapper;
import com.flipkart.aesop.processor.DestinationEventProcessor;
import com.linkedin.databus.client.consumer.AbstractDatabusCombinedConsumer;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusOpcode;
import com.linkedin.databus2.core.DatabusException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public abstract class AbstractEventConsumer
extends AbstractDatabusCombinedConsumer {
    public static final Logger LOGGER = LogFactory.getLogger(AbstractEventConsumer.class);
    protected EventFactory sourceEventFactory;
    protected Mapper mapper;
    protected Map<DbusOpcode, ? extends DestinationEventProcessor> destinationProcessorMap;
    protected Set<Integer> destinationGroupSet;
    protected Integer totalDestinationGroups;

    public ConsumerCallbackResult onDataEvent(DbusEvent event, DbusEventDecoder eventDecoder) {
        return this.processEvent(event, eventDecoder);
    }

    public ConsumerCallbackResult onBootstrapEvent(DbusEvent event, DbusEventDecoder eventDecoder) {
        return this.processEvent(event, eventDecoder);
    }

    private ConsumerCallbackResult processEvent(DbusEvent dbusEvent, DbusEventDecoder eventDecoder) {
        AbstractEvent event;
        LOGGER.debug("Source Id is " + dbusEvent.getSourceId());
        try {
            event = this.decodeSourceEvent(dbusEvent, eventDecoder);
            LOGGER.info("Event : " + event.toString());
        }
        catch (DatabusException ex) {
            LOGGER.error("error in consuming events", (Throwable)ex);
            return ConsumerCallbackResult.ERROR;
        }
        return this.processSourceEvent(event);
    }

    public abstract AbstractEvent decodeSourceEvent(DbusEvent var1, DbusEventDecoder var2) throws DatabusException;

    public abstract ConsumerCallbackResult processSourceEvent(AbstractEvent var1);

    public Set<Integer> getDestinationGroupSet() {
        return this.destinationGroupSet;
    }

    public void setTotalDestinationGroups(Integer totalDestinationGroups) {
        this.totalDestinationGroups = totalDestinationGroups;
    }

    public static abstract class Builder<T> {
        protected EventFactory sourceEventFactory;
        protected Mapper mapper;
        protected Map<DbusOpcode, ? extends DestinationEventProcessor> destinationProcessorMap;
        protected Set<Integer> destinationGroupSet = new HashSet<Integer>();
        protected Integer totalDestinationGroups = 1;

        public Builder(EventFactory sourceEventFactory, Mapper mapper, Map<DbusOpcode, ? extends DestinationEventProcessor> destinationProcessorMap) {
            this.sourceEventFactory = sourceEventFactory;
            this.mapper = mapper;
            this.destinationProcessorMap = destinationProcessorMap;
        }

        public EventFactory getSourceEventFactory() {
            return this.sourceEventFactory;
        }

        public Mapper getMapper() {
            return this.mapper;
        }

        public Map<DbusOpcode, ? extends DestinationEventProcessor> getDestinationProcessorMap() {
            return this.destinationProcessorMap;
        }

        public Set<Integer> getDestinationGroupSet() {
            return this.destinationGroupSet;
        }

        public Integer getTotalDestinationGroups() {
            return this.totalDestinationGroups;
        }

        public Builder<T> withDestinationGroupSet(Set<Integer> destinationGroupSet) {
            this.destinationGroupSet = destinationGroupSet;
            return this;
        }

        public Builder<T> withTotalDestinationGroups(Integer totalDestinationGroups) {
            this.totalDestinationGroups = totalDestinationGroups;
            return this;
        }

        public abstract T build();
    }
}

