/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.mapper.config.implementation;

import com.flipkart.aesop.mapper.config.MapperConfig;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperConfigImpl
implements MapperConfig {
    ConcurrentHashMap<String, Config> cachedConfigMap = new ConcurrentHashMap();

    private MapperConfigImpl() {
    }

    public static MapperConfig getInstance() {
        return SingletonHelper.MAPPER_CONFIG;
    }

    @Override
    public void readConfig(String filePath) {
        this.cachedConfigMap.putIfAbsent(filePath, ConfigFactory.parseFile((File)new File(filePath)));
    }

    @Override
    public Config getConfig(String filePath) {
        if (!this.cachedConfigMap.contains(filePath)) {
            this.readConfig(filePath);
        }
        return this.cachedConfigMap.get(filePath);
    }

    @Override
    public ConfigList getConfigList(String filePath, String keyPath) {
        Config config = this.getConfig(filePath);
        return config.getList(keyPath);
    }

    @Override
    public ConfigList getConfigList(Config config, String keyPath) {
        return config.getList(keyPath);
    }

    @Override
    public ConfigValue getConfigValue(Config config, String keyPath) {
        return config.getValue(keyPath);
    }

    @Override
    public String getValueForKeyAsString(String key, ConfigValue configValue) {
        ConfigObject configObject = (ConfigObject)configValue;
        ConfigValue internalConfigValue = configObject.get((Object)key);
        Object unwrappedConfig = internalConfigValue.unwrapped();
        return unwrappedConfig.toString();
    }

    @Override
    public <T extends ConfigValue> T getValueForKeyAsConfigValue(String key, ConfigValue configValue, Class<T> classType) {
        ConfigObject configObject = (ConfigObject)configValue;
        ConfigValue internalConfigValue = configObject.get((Object)key);
        return (T)((ConfigValue)classType.cast(internalConfigValue));
    }

    @Override
    public Boolean checkIfPathExists(String keyPath, ConfigValue configValue) {
        Config config = (Config)configValue;
        return this.checkIfPathExists(keyPath, config);
    }

    @Override
    public Boolean checkIfPathExists(String keyPath, Config config) {
        return config.hasPath(keyPath);
    }

    @Override
    public Boolean checkIfKeyExists(String keyPath, ConfigValue configValue) {
        ConfigObject configObject = (ConfigObject)configValue;
        return configObject.containsKey((Object)keyPath);
    }

    /* synthetic */ MapperConfigImpl(MapperConfigImpl mapperConfigImpl) {
        this();
    }

    private static class SingletonHelper {
        public static final MapperConfig MAPPER_CONFIG = new MapperConfigImpl(null);

        private SingletonHelper() {
        }
    }
}

