/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.eventconsumer;

import com.flipkart.aesop.destinationoperation.DestinationStoreOperation;
import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.event.EventFactory;
import com.flipkart.aesop.mapper.Mapper;
import com.linkedin.databus.client.consumer.AbstractDatabusCombinedConsumer;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusOpcode;
import com.linkedin.databus2.core.DatabusException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventConsumer
extends AbstractDatabusCombinedConsumer {
    public static final Logger LOGGER = LogFactory.getLogger(AbstractEventConsumer.class);
    protected EventFactory sourceEventFactory;
    protected Mapper mapper;
    protected Map<DbusOpcode, ? extends DestinationStoreOperation> destinationOperationsMap;
    protected Set<Integer> destinationGroupSet;
    protected Integer totalDestinationGroups;

    public ConsumerCallbackResult onDataEvent(DbusEvent event, DbusEventDecoder eventDecoder) {
        return this.processEvent(event, eventDecoder);
    }

    public ConsumerCallbackResult onBootstrapEvent(DbusEvent event, DbusEventDecoder eventDecoder) {
        return this.processEvent(event, eventDecoder);
    }

    private ConsumerCallbackResult processEvent(DbusEvent dbusEvent, DbusEventDecoder eventDecoder) {
        LOGGER.debug("Source Id is " + dbusEvent.getSourceId());
        AbstractEvent event = null;
        try {
            event = this.decodeSourceEvent(dbusEvent, eventDecoder);
            LOGGER.info("Event : " + event.toString());
        }
        catch (DatabusException ex) {
            LOGGER.error("error in consuming events", (Throwable)ex);
            return ConsumerCallbackResult.ERROR;
        }
        return this.processSourceEvent(event);
    }

    public abstract AbstractEvent decodeSourceEvent(DbusEvent var1, DbusEventDecoder var2) throws DatabusException;

    public abstract ConsumerCallbackResult processSourceEvent(AbstractEvent var1);

    public Set<Integer> getDestinationGroupSet() {
        return this.destinationGroupSet;
    }

    public void setTotalDestinationGroups(Integer totalDestinationGroups) {
        this.totalDestinationGroups = totalDestinationGroups;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<T> {
        protected EventFactory sourceEventFactory;
        protected Mapper mapper;
        protected Map<DbusOpcode, ? extends DestinationStoreOperation> destinationOperationsMap;
        protected Set<Integer> destinationGroupSet = new HashSet<Integer>();
        protected Integer totalDestinationGroups = 1;

        public Builder(EventFactory sourceEventFactory, Mapper mapper, Map<DbusOpcode, ? extends DestinationStoreOperation> destinationOperationsMap) {
            this.sourceEventFactory = sourceEventFactory;
            this.mapper = mapper;
            this.destinationOperationsMap = destinationOperationsMap;
        }

        public EventFactory getSourceEventFactory() {
            return this.sourceEventFactory;
        }

        public Mapper getMapper() {
            return this.mapper;
        }

        public Map<DbusOpcode, ? extends DestinationStoreOperation> getDestinationOperationsMap() {
            return this.destinationOperationsMap;
        }

        public Set<Integer> getDestinationGroupSet() {
            return this.destinationGroupSet;
        }

        public Integer getTotalDestinationGroups() {
            return this.totalDestinationGroups;
        }

        public Builder<T> destinationGroupSet(Set<Integer> destinationGroupSet) {
            this.destinationGroupSet = destinationGroupSet;
            return this;
        }

        public Builder<T> totalDestinationGroups(Integer totalDestinationGroups) {
            this.totalDestinationGroups = totalDestinationGroups;
            return this;
        }

        public abstract T build();
    }
}

