/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.mapper.implementation;

import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.event.implementation.DestinationEventFactory;
import com.flipkart.aesop.mapper.config.MapperConfig;
import com.flipkart.aesop.mapper.enums.EntityExistInConfig;
import com.flipkart.aesop.mapper.enums.MapAllValues;
import com.flipkart.aesop.mapper.enums.NamespaceExistInConfig;
import com.flipkart.aesop.mapper.eventGroupFilter.EventGroupFinder;
import com.flipkart.aesop.mapper.utils.MapperHelper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MapperType {
    MAP_WITHOUT_SOURCE_NAMESPACE_ENTITY_CONFIG(NamespaceExistInConfig.FALSE, EntityExistInConfig.FALSE){

        @Override
        public List<AbstractEvent> map(Config config, String configRoot, AbstractEvent sourceEvent, Set<Integer> destinationGroupSet, int totalDestinationGroups) {
            ConfigValue configValue = this.mapperConfig.getConfigValue(config, configRoot);
            Set<String> exclusionSet = this.getExclusionSet(configValue);
            MapAllValues mapAll = this.getMapAll(configValue);
            if (mapAll == MapAllValues.FALSE || exclusionSet.contains(sourceEvent.getNamespaceName())) {
                return new ArrayList<AbstractEvent>();
            }
            AbstractEvent destinationEvent = this.destinationEventFactory.createEvent(sourceEvent.getFieldMapPair(), sourceEvent.getPrimaryKeySet(), sourceEvent.getEntityName(), sourceEvent.getNamespaceName(), sourceEvent.getEventType());
            return Arrays.asList(destinationEvent);
        }
    }
    ,
    MAP_WITHOUT_SOURCE_ENTITY_CONFIG(NamespaceExistInConfig.TRUE, EntityExistInConfig.FALSE){

        @Override
        public List<AbstractEvent> map(Config config, String configRoot, AbstractEvent sourceEvent, Set<Integer> destinationGroupSet, int totalDestinationGroups) {
            String namespacePath = MapperHelper.getNamespacePath(configRoot, sourceEvent);
            ConfigValue configValue = this.mapperConfig.getConfigValue(config, namespacePath);
            Set<String> exclusionSet = this.getExclusionSet(configValue);
            MapAllValues mapAll = this.getMapAll(configValue);
            if (mapAll == MapAllValues.FALSE || exclusionSet.contains(sourceEvent.getEntityName())) {
                return new ArrayList<AbstractEvent>();
            }
            AbstractEvent destinationEvent = this.destinationEventFactory.createEvent(sourceEvent.getFieldMapPair(), sourceEvent.getPrimaryKeySet(), sourceEvent.getEntityName(), sourceEvent.getNamespaceName(), sourceEvent.getEventType());
            return Arrays.asList(destinationEvent);
        }
    }
    ,
    MAP_WITH_SOURCE_ENTITY_CONFIG(NamespaceExistInConfig.TRUE, EntityExistInConfig.TRUE){

        @Override
        public List<AbstractEvent> map(Config config, String configRoot, AbstractEvent sourceEvent, Set<Integer> destinationGroupSet, int totalDestinationGroups) {
            ArrayList<AbstractEvent> destinationEventList = new ArrayList<AbstractEvent>();
            String entityPath = MapperHelper.getEntityPath(configRoot, sourceEvent);
            ConfigList configList = this.mapperConfig.getConfigList(config, entityPath);
            for (ConfigValue destinationConfig : configList) {
                int groupNo;
                String destinationNamespace = sourceEvent.getNamespaceName();
                if (this.mapperConfig.checkIfKeyExists("destinationNamespace", destinationConfig).booleanValue()) {
                    destinationNamespace = this.mapperConfig.getValueForKeyAsString("destinationNamespace", destinationConfig);
                }
                String destinationEntity = sourceEvent.getEntityName();
                if (this.mapperConfig.checkIfKeyExists("destinationEntity", destinationConfig).booleanValue()) {
                    destinationEntity = this.mapperConfig.getValueForKeyAsString("destinationEntity", destinationConfig);
                }
                if (!destinationGroupSet.contains(groupNo = this.getEventGroupNo(totalDestinationGroups, destinationConfig, destinationNamespace, destinationEntity))) continue;
                MapAllValues mapAll = this.getMapAll(destinationConfig);
                Set<String> exclusionSet = this.getExclusionSet(destinationConfig);
                Map<String, Object> destinationEventColumnMap = this.getColumnMap(sourceEvent, destinationConfig, mapAll, exclusionSet);
                Set<String> primaryKeySet = this.getPrimaryKeySet(sourceEvent, destinationConfig);
                AbstractEvent destinationEvent = this.destinationEventFactory.createEvent(destinationEventColumnMap, primaryKeySet, destinationEntity, destinationNamespace, sourceEvent.getEventType());
                destinationEventList.add(destinationEvent);
            }
            return destinationEventList;
        }
    };

    protected NamespaceExistInConfig namespacePathExists;
    protected EntityExistInConfig entityPathExists;
    protected MapperConfig mapperConfig;
    protected EventGroupFinder eventGroupFinder;
    protected DestinationEventFactory destinationEventFactory;

    protected Set<String> getPrimaryKeySet(AbstractEvent sourceEvent, ConfigValue destinationConfig) {
        Set<String> primaryKeySet;
        if (this.mapperConfig.checkIfKeyExists("primaryKeyList", destinationConfig).booleanValue()) {
            ConfigList primaryKeyConfigObject = this.mapperConfig.getValueForKeyAsConfigValue("primaryKeyList", destinationConfig, ConfigList.class);
            primaryKeySet = new HashSet<String>();
            for (ConfigValue configValue : primaryKeyConfigObject) {
                if (configValue.unwrapped() == null) continue;
                primaryKeySet.add(configValue.unwrapped().toString());
            }
        } else {
            primaryKeySet = sourceEvent.getPrimaryKeySet();
        }
        return primaryKeySet;
    }

    protected Map<String, Object> getColumnMap(AbstractEvent sourceEvent, ConfigValue destinationConfig, MapAllValues mapAll, Set<String> exclusionSet) {
        Map<String, Object> destinationEventColumnMap = null;
        if (this.mapperConfig.checkIfKeyExists("columnMap", destinationConfig).booleanValue()) {
            ConfigObject columnMappingConfigObject = this.mapperConfig.getValueForKeyAsConfigValue("columnMap", destinationConfig, ConfigObject.class);
            destinationEventColumnMap = MapperHelper.getDestinationEventColumnMapping(sourceEvent.getFieldMapPair(), columnMappingConfigObject, mapAll, exclusionSet);
        } else {
            destinationEventColumnMap = MapperHelper.getDestinationEventColumnMapping(sourceEvent.getFieldMapPair(), null, mapAll, exclusionSet);
        }
        return destinationEventColumnMap;
    }

    protected Set<String> getExclusionSet(ConfigValue destinationConfig) {
        HashSet<String> exclusionSet = new HashSet<String>();
        if (this.mapperConfig.checkIfKeyExists("exclusionList", destinationConfig).booleanValue()) {
            ConfigList exclusionListConfigObject = this.mapperConfig.getValueForKeyAsConfigValue("exclusionList", destinationConfig, ConfigList.class);
            exclusionSet = new HashSet();
            for (ConfigValue configValue : exclusionListConfigObject) {
                if (configValue.unwrapped() == null) continue;
                exclusionSet.add(configValue.unwrapped().toString());
            }
        }
        return exclusionSet;
    }

    protected MapAllValues getMapAll(ConfigValue destinationConfig) {
        MapAllValues mapAll = MapAllValues.FALSE;
        if (this.mapperConfig.checkIfKeyExists("mapAll", destinationConfig).booleanValue()) {
            String mapAllValue = this.mapperConfig.getValueForKeyAsString("mapAll", destinationConfig);
            mapAll = MapAllValues.valueOf(mapAllValue.toUpperCase());
        }
        return mapAll;
    }

    protected int getEventGroupNo(int totalDestinationGroups, ConfigValue destinationConfig, String destinationNamespace, String destinationEntity) {
        int groupNo = 1;
        if (this.mapperConfig.checkIfKeyExists("groupNo", destinationConfig).booleanValue()) {
            String configGroupNo = this.mapperConfig.getValueForKeyAsString("groupNo", destinationConfig);
            groupNo = Integer.parseInt(configGroupNo);
        } else {
            groupNo = this.eventGroupFinder.getEventGroupNo(destinationNamespace, destinationEntity, totalDestinationGroups);
        }
        return groupNo;
    }

    private MapperType(NamespaceExistInConfig namespacePathExists, EntityExistInConfig entityPathExists) {
        this.namespacePathExists = namespacePathExists;
        this.entityPathExists = entityPathExists;
    }

    public abstract List<AbstractEvent> map(Config var1, String var2, AbstractEvent var3, Set<Integer> var4, int var5);

    public void setMapperConfig(MapperConfig mapperConfig) {
        this.mapperConfig = mapperConfig;
    }

    public void setEventGroupFinder(EventGroupFinder eventGroupFinder) {
        this.eventGroupFinder = eventGroupFinder;
    }

    public void setDestinationEventFactory(DestinationEventFactory destinationEventFactory) {
        this.destinationEventFactory = destinationEventFactory;
    }
}

