/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.bootstrap.mysql.eventprocessor.impl;

import com.flipkart.aesop.bootstrap.mysql.eventlistener.OpenReplicationListener;
import com.flipkart.aesop.bootstrap.mysql.eventprocessor.BinLogEventProcessor;
import com.google.code.or.binlog.BinlogEventV4;
import com.google.code.or.binlog.impl.event.WriteRowsEvent;
import com.linkedin.databus.core.DbusOpcode;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class InsertEventProcessor
implements BinLogEventProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(InsertEventProcessor.class);

    public void process(BinlogEventV4 event, OpenReplicationListener listener) throws Exception {
        if (!listener.getMysqlTransactionManager().isBeginTxnSeen()) {
            LOGGER.warn("Skipping event (" + event + ") as this is before the start of first transaction");
            return;
        }
        LOGGER.debug("Insert Event Received : " + event);
        WriteRowsEvent wre = (WriteRowsEvent)event;
        listener.getMysqlTransactionManager().performChanges(wre.getTableId(), wre.getHeader(), wre.getRows(), DbusOpcode.UPSERT);
        LOGGER.debug("Insertion Successful for  " + event.getHeader().getEventLength() + " . Data inserted : " + wre.getRows());
    }
}

