/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.bootstrap.mysql.eventlistener;

import com.flipkart.aesop.bootstrap.mysql.eventprocessor.BinLogEventProcessor;
import com.flipkart.aesop.bootstrap.mysql.txnprocessor.MysqlTransactionManager;
import com.google.code.or.binlog.BinlogEventListener;
import com.google.code.or.binlog.BinlogEventV4;
import java.util.Map;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class OpenReplicationListener
implements BinlogEventListener {
    private static final Logger LOGGER = LogFactory.getLogger(OpenReplicationListener.class);
    private final MysqlTransactionManager mysqlTransactionManager;
    private Map<Integer, BinLogEventProcessor> processors;
    private String binLogPrefix;

    public OpenReplicationListener(MysqlTransactionManager mysqlTransactionManager, Map<Integer, BinLogEventProcessor> processors, String binLogPrefix) {
        this.mysqlTransactionManager = mysqlTransactionManager;
        this.processors = processors;
        this.binLogPrefix = binLogPrefix;
    }

    public void onEvents(BinlogEventV4 event) {
        if (event == null) {
            LOGGER.error("Received null event");
            return;
        }
        LOGGER.info("Current SCN:" + event.getHeader().getPosition());
        try {
            BinLogEventProcessor processor = this.processors.get(event.getHeader().getEventType());
            if (processor != null) {
                processor.process(event, this);
            } else {
                LOGGER.warn("Ignoring Unsupported Event! " + event.getHeader().getEventType());
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while processing event " + e);
        }
    }

    public Map<Integer, BinLogEventProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(Map<Integer, BinLogEventProcessor> processors) {
        this.processors = processors;
    }

    public MysqlTransactionManager getMysqlTransactionManager() {
        return this.mysqlTransactionManager;
    }

    public String getBinLogPrefix() {
        return this.binLogPrefix;
    }

    public void setBinLogPrefix(String binLogPrefix) {
        this.binLogPrefix = binLogPrefix;
    }
}

