/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.bootstrap.mysql.eventprocessor.impl;

import com.flipkart.aesop.bootstrap.mysql.eventlistener.OpenReplicationListener;
import com.flipkart.aesop.bootstrap.mysql.eventprocessor.BinLogEventProcessor;
import com.google.code.or.binlog.BinlogEventV4;
import com.google.code.or.binlog.impl.event.QueryEvent;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class MutatingQueryEventProcessor
implements BinLogEventProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(MutatingQueryEventProcessor.class);

    public void process(BinlogEventV4 event, OpenReplicationListener listener) throws Exception {
        QueryEvent queryEvent = (QueryEvent)event;
        String sql = queryEvent.getSql().toString();
        if ("BEGIN".equalsIgnoreCase(sql)) {
            listener.getMysqlTransactionManager().setBeginTxnSeen(true);
            LOGGER.debug("BEGIN sql: " + sql);
            listener.getMysqlTransactionManager().startXtion();
        } else if ("COMMIT".equalsIgnoreCase(sql)) {
            LOGGER.debug("COMMIT sql: " + sql);
            listener.getMysqlTransactionManager().endXtion(queryEvent.getHeader().getTimestamp());
        } else if ("ROLLBACK".equalsIgnoreCase(sql)) {
            LOGGER.debug("ROLLBACK sql: " + sql);
            listener.getMysqlTransactionManager().resetTxn();
        } else {
            LOGGER.debug("unsupported DDL statement sql: " + sql);
        }
    }
}

