/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.bootstrap.mysql.eventprocessor.impl;

import com.flipkart.aesop.bootstrap.mysql.eventlistener.OpenReplicationListener;
import com.flipkart.aesop.bootstrap.mysql.eventprocessor.BinLogEventProcessor;
import com.flipkart.aesop.event.AbstractEvent;
import com.google.code.or.binlog.BinlogEventV4;
import com.google.code.or.binlog.impl.event.RotateEvent;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotateEventProcessor<T extends AbstractEvent>
implements BinLogEventProcessor<T> {
    public static final Logger LOGGER = LogFactory.getLogger(RotateEventProcessor.class);

    @Override
    public void process(BinlogEventV4 event, OpenReplicationListener<T> listener) {
        String binlogPrefix = listener.getBinlogPrefix();
        RotateEvent rotateEvent = (RotateEvent)event;
        String fileName = rotateEvent.getBinlogFileName().toString();
        LOGGER.info("File Rotated : FileName :" + fileName);
        String fileNumStr = fileName.substring(fileName.lastIndexOf(binlogPrefix) + binlogPrefix.length() + 1);
        Long fileNumber = Long.parseLong(fileNumStr);
        LOGGER.info("BinlogFile Number : " + fileNumber);
        if (fileNumber.equals(listener.getEndFileNum())) {
            LOGGER.info("Bootstrap Process completed successfully !!!");
            listener.getSourceEventConsumer().shutdown();
            listener.shutdown();
        }
    }
}

