/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.bootstrap.mysql;

import com.flipkart.aesop.bootstrap.mysql.configs.OpenReplicatorConfig;
import com.flipkart.aesop.bootstrap.mysql.eventlistener.OpenReplicationListener;
import com.flipkart.aesop.bootstrap.mysql.eventprocessor.BinLogEventProcessor;
import com.flipkart.aesop.runtime.bootstrap.producer.BlockingEventProducer;
import com.google.code.or.OpenReplicator;
import com.google.code.or.binlog.BinlogEventListener;
import com.linkedin.databus2.schemas.FileSystemSchemaRegistryService;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MysqlEventProducer
extends BlockingEventProducer {
    public static final Logger LOGGER = LogFactory.getLogger(MysqlEventProducer.class);
    private static Long startTime = System.nanoTime();
    private OpenReplicatorConfig openReplicatorConfig;
    private Map<Integer, BinLogEventProcessor> eventProcessors;
    private OpenReplicator openReplicator = new OpenReplicator();

    public void start(long l) {
        try {
            FileSystemSchemaRegistryService.Config configBuilder = new FileSystemSchemaRegistryService.Config();
            configBuilder.setFallbackToResources(true);
            configBuilder.setSchemaDir(this.bootstrapConfig.getSchemaRegistryLocation());
            FileSystemSchemaRegistryService.StaticConfig schemaRegistryServiceConfig = configBuilder.build();
            this.schemaRegistryService = FileSystemSchemaRegistryService.build((FileSystemSchemaRegistryService.StaticConfig)schemaRegistryServiceConfig);
            OpenReplicationListener orListener = new OpenReplicationListener(this.openReplicatorConfig.getBinlogPrefix(), this.openReplicatorConfig.getEndFileNumber(), this.interestedSourceList, this.tableUriToSrcNameMap, this.schemaRegistryService, this.sourceEventConsumer, this.eventProcessors, this);
            String binlogFile = String.format("%s.%06d", this.openReplicatorConfig.getBinlogPrefix(), this.openReplicatorConfig.getStartFileNumber());
            this.openReplicator.setBinlogFileName(binlogFile);
            this.openReplicator.setBinlogPosition(this.openReplicatorConfig.getBinlogPosition());
            this.openReplicator.setBinlogEventListener((BinlogEventListener)orListener);
            this.openReplicator.setUser(this.openReplicatorConfig.getUserName());
            this.openReplicator.setPassword(this.openReplicatorConfig.getPassword());
            this.openReplicator.setHost(this.openReplicatorConfig.getHost());
            this.openReplicator.setPort(this.openReplicatorConfig.getPort());
            this.openReplicator.setServerId(this.openReplicatorConfig.getServerId());
            this.openReplicator.start();
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while starting open replication.", (Throwable)e);
        }
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public long getSCN() {
        return 0L;
    }

    public boolean isRunning() {
        return this.openReplicator.isRunning();
    }

    public boolean isPaused() {
        return !this.openReplicator.isRunning();
    }

    public void unpause() {
        throw new UnsupportedOperationException("'unpause' is not supported on this event producer");
    }

    public void pause() {
        throw new UnsupportedOperationException("'unpause' is not supported on this event producer");
    }

    public void shutdown() {
        try {
            LOGGER.info("Shutdown has been requested. MYSQLEventProducer shutting down");
            this.openReplicator.stop(5L, TimeUnit.SECONDS);
            LOGGER.info("### Bootstrap Process completed successfully ###");
            LOGGER.info("Time Taken:" + (System.nanoTime() - startTime));
        }
        catch (Exception e) {
            LOGGER.error("Error while stopping mysql bootstrap", (Throwable)e);
        }
    }

    public void waitForShutdown() throws InterruptedException, IllegalStateException {
        throw new UnsupportedOperationException("'waitForShutdown' is not supported on this event producer");
    }

    public void waitForShutdown(long l) throws InterruptedException, IllegalStateException {
        throw new UnsupportedOperationException("'waitForShutdown' is not supported on this event producer");
    }

    public OpenReplicatorConfig getOpenReplicatorConfig() {
        return this.openReplicatorConfig;
    }

    public void setOpenReplicatorConfig(OpenReplicatorConfig openReplicatorConfig) {
        this.openReplicatorConfig = openReplicatorConfig;
    }

    public Map<Integer, BinLogEventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    public void setEventProcessors(Map<Integer, BinLogEventProcessor> eventProcessors) {
        this.eventProcessors = eventProcessors;
    }
}

