/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.avro.schemagenerator.mysql;

import com.flipkart.aesop.avro.schemagenerator.data.TableRecord;
import com.flipkart.aesop.avro.schemagenerator.mysql.MysqlConnectionProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MysqlUtils {
    private static final String FIELDS_FETCH_QUERY = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ? and TABLE_NAME = ?";
    private static final String TABLES_FETCH_QUERY = "SELECT TABLE_NAME AS table_name FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = ?";
    private static final String TABLE_CHECK_QUERY = "SELECT count(*) AS count FROM ";
    private static final String FIELDS_DETAILS_FETCH_QUERY = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ? and TABLE_NAME = ?";

    private static void releaseDBResource(Connection connection, ResultSet resultSet, Statement statement) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTablesInDB(String dbName) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            connection = MysqlConnectionProvider.getInstance().getConnection(dbName);
            preparedStatement = connection.prepareStatement(TABLES_FETCH_QUERY);
            preparedStatement.setString(1, dbName);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                list.add(resultSet.getString("table_name"));
            }
        }
        catch (SQLException e) {
            try {
                System.out.println("ERROR: Unable to fetch the table names in the database specified: " + e.toString());
            }
            catch (Throwable throwable) {
                MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
                throw throwable;
            }
            MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
        }
        MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPrimaryKeys(String dbName, String tableName) {
        ArrayList<String> primaryKeyList = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = MysqlConnectionProvider.getInstance().getConnection(dbName);
            String primaryKeyFetchQuery = "SHOW index FROM " + tableName + " WHERE Key_name = 'PRIMARY'";
            preparedStatement = connection.prepareStatement(primaryKeyFetchQuery);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                primaryKeyList.add(resultSet.getString("Column_name"));
            }
            MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
        }
        return primaryKeyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFieldsInTable(String db, String table) {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = MysqlConnectionProvider.getInstance().getConnection(db);
            preparedStatement = connection.prepareStatement(FIELDS_FETCH_QUERY);
            preparedStatement.setString(1, db);
            preparedStatement.setString(2, table);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                list.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        catch (SQLException e) {
            try {
                System.out.println("Unable to determine the fields from the given table: " + e.toString());
            }
            catch (Throwable throwable) {
                MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
                throw throwable;
            }
            MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
        }
        MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidTable(String dataBase, String table) {
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        Connection connection;
        block4: {
            boolean bl;
            connection = null;
            resultSet = null;
            preparedStatement = null;
            try {
                connection = MysqlConnectionProvider.getInstance().getConnection(dataBase);
                preparedStatement = connection.prepareStatement(TABLE_CHECK_QUERY + table);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next() || resultSet.getInt("count") < 0) break block4;
                bl = true;
            }
            catch (SQLException e) {
                boolean bl2;
                try {
                    System.out.println("ERROR: Unable to determine if it's a valid schema : " + e.toString());
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
                    throw throwable;
                }
                MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
                return bl2;
            }
            MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
            return bl;
        }
        MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidField(String database, String field, String table) {
        boolean bl;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = MysqlConnectionProvider.getInstance().getConnection(database);
            preparedStatement = connection.prepareStatement("SELECT count(COLUMN_NAME)  as count FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ? and TABLE_NAME = ? and COLUMN_NAME = ?");
            preparedStatement.setString(1, database);
            preparedStatement.setString(2, table);
            preparedStatement.setString(3, field);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.next() && resultSet.getInt("count") > 0;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                System.out.println("ERROR: Unable to determine if it's a valid field ( " + field + "): " + e.toString());
                bl2 = false;
            }
            catch (Throwable throwable) {
                MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
                throw throwable;
            }
            MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
            return bl2;
        }
        MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TableRecord.Field> getFieldDetails(String db, String table) {
        ArrayList<TableRecord.Field> fieldInfoList = new ArrayList<TableRecord.Field>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = MysqlConnectionProvider.getInstance().getConnection(db);
            preparedStatement = connection.prepareStatement(FIELDS_DETAILS_FETCH_QUERY);
            preparedStatement.setString(1, db);
            preparedStatement.setString(2, table);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                fieldInfoList.add(new TableRecord.Field(resultSet.getString("COLUMN_NAME"), resultSet.getString("DATA_TYPE"), resultSet.getInt("ORDINAL_POSITION")));
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
                throw throwable;
            }
            MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
        }
        MysqlUtils.releaseDBResource(connection, resultSet, preparedStatement);
        return fieldInfoList;
    }
}

