/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.avro.schemagenerator.mysql;

import com.flipkart.aesop.avro.schemagenerator.mysql.DataSourceConfig;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.RuntimeErrorException;
import javax.sql.DataSource;

public class MysqlConnectionProvider {
    private static final String DEFAULT_MYSQL_JDBC_DRIVER = "com.mysql.jdbc.Driver";
    private static ConcurrentMap<String, DataSource> dataSources = new ConcurrentHashMap<String, DataSource>();
    private static MysqlConnectionProvider instance = new MysqlConnectionProvider();

    public static MysqlConnectionProvider getInstance() {
        return instance;
    }

    private DataSource setupDataSource(DataSourceConfig dataSourceConfig) throws PropertyVetoException {
        ComboPooledDataSource cpds = new ComboPooledDataSource();
        cpds.setDriverClass(DEFAULT_MYSQL_JDBC_DRIVER);
        cpds.setJdbcUrl(dataSourceConfig.getJDBCString());
        cpds.setMinPoolSize(dataSourceConfig.getMinPoolSize());
        cpds.setMaxPoolSize(dataSourceConfig.getMaxPoolSize());
        cpds.setTestConnectionOnCheckin(true);
        return cpds;
    }

    public void addDataSource(DataSourceConfig dataSourceConfig) throws PropertyVetoException {
        dataSources.putIfAbsent(dataSourceConfig.getDbName(), this.setupDataSource(dataSourceConfig));
    }

    public Connection getConnection(String dataSourceId) throws SQLException {
        if (dataSources.containsKey(dataSourceId)) {
            return ((DataSource)dataSources.get(dataSourceId)).getConnection();
        }
        throw new RuntimeErrorException(null, "No dataSouce found for dataSourceId : " + dataSourceId);
    }
}

