/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.abservice.store.impl;

import com.flipkart.abservice.distribution.ExperimentDistribution;
import com.flipkart.abservice.distribution.impl.RandomProbabilityDistribution;
import com.flipkart.abservice.pojo.ABExperimentConfig;
import com.flipkart.abservice.store.ExperimentConfigStore;
import com.flipkart.abservice.store.config.ConfigService;
import com.flipkart.cfgsvc.blogic.DProperty;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConmanConfigStore
extends ExperimentConfigStore {
    private static ConmanConfigStore instance;
    private static Logger LOGGER;
    private static String hostName;
    Map<String, ABExperimentConfig> configs = new HashMap<String, ABExperimentConfig>();
    private Map<String, ExperimentDistribution> experimentRegistry = new HashMap<String, ExperimentDistribution>();

    public static ConmanConfigStore getInstance() {
        if (instance == null) {
            instance = new ConmanConfigStore();
        }
        return instance;
    }

    private ConmanConfigStore() {
    }

    @Override
    public void initialize() throws Exception {
        if (hostName != null && !hostName.isEmpty()) {
            ConfigService.setHostName(hostName);
        }
        this.experimentRegistry.put("RandomProbability", new RandomProbabilityDistribution());
        Map<String, DProperty> configMap = ConfigService.getInstance().getAllConfig();
        if (configMap.containsKey("configRefreshInterval")) {
            ConfigService.setConfigRefreshInterval(Integer.valueOf(configMap.get((Object)"configRefreshInterval").content));
            configMap.remove("configRefreshInterval");
        }
        for (String expKey : configMap.keySet()) {
            ABExperimentConfig config = new ABExperimentConfig();
            if (!config.setConfigFromJson(configMap.get((Object)expKey).content).booleanValue()) {
                LOGGER.error("syntax error in config, experiment does not have all mandatory fields: " + expKey);
                continue;
            }
            ExperimentDistribution experimentDistribution = this.experimentRegistry.get(config.getType());
            if (experimentDistribution.validateConfig(config.getBranches())) {
                this.setExperimentConfig(config);
                continue;
            }
            System.out.println("invalid config" + expKey);
            LOGGER.error("invalid bucket distribution for: " + expKey);
        }
    }

    @Override
    public Map<String, ABExperimentConfig> getAllExperimentConfig() {
        return this.configs;
    }

    public ExperimentDistribution getExperimentDistribution(String expType) {
        return this.experimentRegistry.containsKey(expType) ? this.experimentRegistry.get(expType) : null;
    }

    @Override
    public ABExperimentConfig getExperimentConfig(String expID) {
        if (this.configs.containsKey(expID)) {
            return this.configs.get(expID);
        }
        return null;
    }

    @Override
    public boolean setExperimentConfig(ABExperimentConfig experimentConfig) {
        this.configs.put(experimentConfig.getExp_id(), experimentConfig);
        return true;
    }

    @Override
    public boolean updateExperimentConfig(ABExperimentConfig experimentConfig) {
        if (this.configs.containsKey(experimentConfig.getExp_id())) {
            this.configs.put(experimentConfig.getExp_id(), experimentConfig);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteExperimentConfig(String expID) {
        if (this.configs.containsKey(expID)) {
            this.configs.remove(expID);
            return true;
        }
        return false;
    }

    public static void setHostName(String hostName) {
        ConmanConfigStore.hostName = hostName;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ConmanConfigStore.class);
        hostName = null;
    }
}

