/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.abservice.store.config;

import com.flipkart.abservice.pojo.ABExperimentConfig;
import com.flipkart.abservice.resources.ABService;
import com.flipkart.abservice.store.config.ConfigService;
import com.flipkart.abservice.store.impl.ConmanConfigStore;
import com.flipkart.cfgsvc.blogic.DProperty;
import com.flipkart.cfgsvc.client.IUpdateListener;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUpdateListener
implements IUpdateListener {
    private static ConfigUpdateListener instance = new ConfigUpdateListener();
    private static Logger LOGGER = LoggerFactory.getLogger(ABService.class);
    private static final String configRefreshInterval = "configRefreshInterval";

    public static ConfigUpdateListener singleton() {
        return instance;
    }

    public void onUpdate(IUpdateListener.Metadata metadata) {
        Map newConfigMap = metadata.getNewProperties();
        Map oldConfigMap = metadata.getOldProperties();
        if (newConfigMap.containsKey(configRefreshInterval)) {
            Integer newRefreshInterval;
            Integer oldRefreshInterval = 0;
            if (oldConfigMap != null && oldConfigMap.containsKey(configRefreshInterval)) {
                oldRefreshInterval = Integer.valueOf(((DProperty)oldConfigMap.get((Object)configRefreshInterval)).content);
            }
            if (!oldRefreshInterval.equals(newRefreshInterval = Integer.valueOf(((DProperty)newConfigMap.get((Object)configRefreshInterval)).content))) {
                ConfigService.setConfigRefreshInterval(newRefreshInterval);
            }
            newConfigMap.remove(configRefreshInterval);
        }
        for (String newConfigKey : newConfigMap.keySet()) {
            ABExperimentConfig experimentConfig = new ABExperimentConfig();
            if (!experimentConfig.setConfigFromJson(((DProperty)newConfigMap.get((Object)newConfigKey)).content).booleanValue()) {
                LOGGER.error("syntax error in config, experiment does not have all mandatory fields: " + newConfigKey);
                continue;
            }
            if (oldConfigMap.containsKey(newConfigKey) && !((DProperty)oldConfigMap.get((Object)newConfigKey)).content.equals(((DProperty)newConfigMap.get((Object)newConfigKey)).content)) {
                ABExperimentConfig oldConfig = ConmanConfigStore.getInstance().getExperimentConfig(experimentConfig.getExp_id());
                String oldVersion = "0";
                if (oldConfig != null) {
                    oldVersion = oldConfig.getVersion();
                }
                if (Float.valueOf(experimentConfig.getVersion()).floatValue() > Float.valueOf(oldVersion).floatValue()) {
                    ABService.getInstance().addExperimentToABIdTable(experimentConfig);
                    ConmanConfigStore.getInstance().setExperimentConfig(experimentConfig);
                    ABService.getInstance().removeExperimentFromABIdTable(oldConfig);
                    continue;
                }
                ConmanConfigStore.getInstance().setExperimentConfig(experimentConfig);
                continue;
            }
            if (oldConfigMap.containsKey(newConfigKey)) continue;
            ABService.getInstance().addExperimentToABIdTable(experimentConfig);
            ConmanConfigStore.getInstance().setExperimentConfig(experimentConfig);
        }
    }
}

