/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.abservice.store.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.abservice.store.config.ConfigUpdateListener;
import com.flipkart.cfgsvc.blogic.DProperty;
import com.flipkart.cfgsvc.client.CConfiguration;
import com.flipkart.cfgsvc.client.CScheduledUpdate;
import com.flipkart.cfgsvc.client.IConfiguration;
import com.flipkart.cfgsvc.client.IUpdateListener;
import java.util.Map;

public class ConfigService {
    private static CConfiguration configHandler;
    private static ConfigService instance;
    private static final String appName = "fk-cp-ab-service";
    private static final String appVersion = "dummy";
    private static String hostName;
    private static Integer configRefreshInterval;
    private static CScheduledUpdate update;

    public static void setConfigRefreshInterval(Integer configRefreshInterval) {
        ConfigService.configRefreshInterval = configRefreshInterval;
    }

    public static void setHostName(String hostName) {
        ConfigService.hostName = hostName;
    }

    public static ConfigService getInstance() throws Exception {
        if (instance == null) {
            instance = new ConfigService();
        }
        return instance;
    }

    public Map<String, DProperty> getAllConfig() throws Exception {
        return configHandler.getProperties(null);
    }

    public DProperty getConfig(String key) throws Exception {
        if (key != null) {
            return configHandler.getProperty(key);
        }
        throw new Exception("CONFIG_NOT_PRESENT NAME:" + key);
    }

    public <T> T getConfig(String key, Class<T> tClass) throws Exception {
        if (key != null) {
            ObjectMapper om = new ObjectMapper();
            DProperty config = this.getConfig(key);
            return (T)om.readValue(config.content, tClass);
        }
        throw new Exception("CONFIG_NOT_PRESENT NAME:" + key);
    }

    public ConfigService() throws Exception {
        if (configHandler == null) {
            try {
                configHandler = new CConfiguration((IUpdateListener)ConfigUpdateListener.singleton());
                configHandler.initialize(appName, appVersion, hostName, null);
                update = new CScheduledUpdate(1);
                update.add((IConfiguration)configHandler, configRefreshInterval.intValue());
            }
            catch (Exception e) {
                throw new Exception("CONFIG_INITIALIZATION_FAILED EXCEPTION:" + e.getMessage());
            }
        }
    }

    public void updateRefreshInterval(Integer newRefreshInterval) {
        if (configHandler == null) {
            return;
        }
        update.remove((IConfiguration)configHandler);
        update.add((IConfiguration)configHandler, newRefreshInterval.intValue());
        configRefreshInterval = newRefreshInterval;
    }

    static {
        hostName = "local";
        configRefreshInterval = 60;
    }
}

