/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.abservice.rulesEngine.impl;

import com.flipkart.abservice.rulesEngine.Expression;
import java.util.Map;

public class BaseType<T>
implements Expression {
    public T value;
    public Class<T> type;

    public BaseType(T value, Class<T> type) {
        this.value = value;
        this.type = type;
    }

    public T getValue() {
        return this.value;
    }

    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean interpret(Map<String, ?> bindings) {
        return true;
    }

    public static BaseType<?> getBaseType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The provided string must not be null");
        }
        try {
            if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
                return new BaseType<Boolean>(Boolean.getBoolean(string.toLowerCase()), Boolean.class);
            }
            if (string.startsWith("'")) {
                return new BaseType<String>(string.toLowerCase(), String.class);
            }
            if (string.contains(".")) {
                return new BaseType<Float>(Float.valueOf(Float.parseFloat(string)), Float.class);
            }
            return new BaseType<Integer>(Integer.parseInt(string), Integer.class);
        }
        catch (Exception e) {
            return new BaseType<String>(string.toLowerCase(), String.class);
        }
    }
}

