/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.abservice.rulesEngine;

import com.flipkart.abservice.rulesEngine.Expression;
import com.flipkart.abservice.rulesEngine.Operations;
import com.flipkart.abservice.rulesEngine.impl.Operation;
import java.util.ArrayList;
import java.util.Stack;

public class ExpressionParser {
    private static final Operations operations = Operations.INSTANCE;
    private static final String leftBracketStr = "(";
    private static final String rightBracketStr = ")";

    public static Expression fromString(String expr) {
        String[] tokens = expr.split("\\s");
        Stack<Expression> stack = new Stack<Expression>();
        for (int i = 0; i < tokens.length - 1; ++i) {
            Operation op;
            if (tokens[i].equals(leftBracketStr)) {
                int leftBracket = 0;
                ArrayList<String> nextExpressionString = new ArrayList<String>();
                ++leftBracket;
                ++i;
                while (i < tokens.length) {
                    if (!tokens[i].equals(rightBracketStr) || leftBracket != 1) {
                        nextExpressionString.add(tokens[i]);
                    }
                    if (tokens[i].equals(leftBracketStr)) {
                        ++leftBracket;
                    }
                    if (tokens[i].equals(rightBracketStr)) {
                        --leftBracket;
                    }
                    if (leftBracket == 0) break;
                    ++i;
                }
                Expression nextExpression = ExpressionParser.fromString(nextExpressionString.toArray(new String[nextExpressionString.size()]));
                stack.push(nextExpression);
            }
            if ((op = operations.getOperation(tokens[i])) == null) continue;
            op = op.copy();
            i = op.parse(tokens, i, stack);
        }
        return (Expression)stack.pop();
    }

    public static Expression fromString(String[] tokens) {
        Stack<Expression> stack = new Stack<Expression>();
        for (int i = 0; i < tokens.length - 1; ++i) {
            Operation op;
            if (tokens[i].equals(leftBracketStr)) {
                int leftBracket = 0;
                ArrayList<String> nextExpressionString = new ArrayList<String>();
                ++leftBracket;
                ++i;
                while (i < tokens.length) {
                    if (!tokens[i].equals(rightBracketStr) || leftBracket != 1) {
                        nextExpressionString.add(tokens[i]);
                    }
                    if (tokens[i].equals(leftBracketStr)) {
                        ++leftBracket;
                    }
                    if (tokens[i].equals(rightBracketStr)) {
                        --leftBracket;
                    }
                    if (leftBracket == 0) break;
                    ++i;
                }
                Expression nextExpression = ExpressionParser.fromString(nextExpressionString.toArray(new String[nextExpressionString.size()]));
                stack.push(nextExpression);
            }
            if ((op = operations.getOperation(tokens[i])) == null) continue;
            op = op.copy();
            i = op.parse(tokens, i, stack);
        }
        return (Expression)stack.pop();
    }
}

