/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.abservice.resources;

import com.flipkart.abservice.distribution.ExperimentDistribution;
import com.flipkart.abservice.pojo.ABExperimentConfig;
import com.flipkart.abservice.pojo.ABIdTable;
import com.flipkart.abservice.pojo.ABRequest;
import com.flipkart.abservice.pojo.ABRequestWithJunction;
import com.flipkart.abservice.pojo.ABResponse;
import com.flipkart.abservice.pojo.ABResponseWithJunction;
import com.flipkart.abservice.resources.UserVerification;
import com.flipkart.abservice.rulesEngine.Operations;
import com.flipkart.abservice.rulesEngine.impl.operations.And;
import com.flipkart.abservice.rulesEngine.impl.operations.Equals;
import com.flipkart.abservice.rulesEngine.impl.operations.Gt;
import com.flipkart.abservice.rulesEngine.impl.operations.Gte;
import com.flipkart.abservice.rulesEngine.impl.operations.Lt;
import com.flipkart.abservice.rulesEngine.impl.operations.Lte;
import com.flipkart.abservice.rulesEngine.impl.operations.Not;
import com.flipkart.abservice.rulesEngine.impl.operations.Or;
import com.flipkart.abservice.store.ExperimentConfigStore;
import com.flipkart.abservice.store.impl.ConmanConfigStore;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ABService {
    private ExperimentConfigStore experimentConfigStore;
    private static ABService instance;
    private Map<String, String> abIDTable = new HashMap<String, String>();
    private static Logger LOGGER;

    private ABService() {
        Operations operations = Operations.INSTANCE;
        operations.registerOperation(new And());
        operations.registerOperation(new Equals());
        operations.registerOperation(new Gt());
        operations.registerOperation(new Gte());
        operations.registerOperation(new Lt());
        operations.registerOperation(new Lte());
        operations.registerOperation(new Not());
        operations.registerOperation(new Or());
        this.experimentConfigStore = ConmanConfigStore.getInstance();
        try {
            this.experimentConfigStore.initialize();
        }
        catch (Exception e) {
            LOGGER.error("config store initialize failed" + e.getMessage());
        }
        Map<String, ABExperimentConfig> configs = this.experimentConfigStore.getAllExperimentConfig();
        for (String expID : configs.keySet()) {
            ABExperimentConfig expConfig = configs.get(expID);
            this.addExperimentToABIdTable(expConfig);
        }
    }

    public static ABService getInstance() {
        if (instance == null) {
            instance = new ABService();
        }
        return instance;
    }

    public Boolean registerCallback(String expID, UserVerification userVerification) {
        if (this.experimentConfigStore.getExperimentConfig(expID) == null) {
            return false;
        }
        this.experimentConfigStore.getExperimentConfig(expID).setUserVerification(userVerification);
        return true;
    }

    public ABResponse getAB(ABRequest requestData) {
        ABResponse responseData = new ABResponse();
        responseData.setResponseMessage("OK");
        String requestABId = requestData.getAbID();
        String expID = requestData.getExperimentID();
        String forceAssignBranch = requestData.getForceAssignBranch();
        responseData.setAbID(requestABId);
        responseData.setExpID(expID);
        ABExperimentConfig expConfig = null;
        if (requestABId != null && this.abIDTable.containsKey(requestABId)) {
            String abValue = this.abIDTable.get(requestABId);
            ABIdTable abIdTableData = new ABIdTable(abValue);
            expID = abIdTableData.getExpID();
            responseData.setExpID(expID);
            responseData.setBranch(abIdTableData.getBranch());
            responseData.setAbID(requestABId);
        }
        if (expID != null) {
            expConfig = this.experimentConfigStore.getExperimentConfig(expID);
        }
        if (expConfig == null) {
            responseData.setBranch(null);
            responseData.setResponseMessage("ExperimentConfigDoesNotExist");
            return responseData;
        }
        if (expConfig.getUserVerification() != null && !expConfig.getUserVerification().userLiesInSampleSpace(expID, expConfig.getPreMetadata(), requestData.getUserContext()).booleanValue()) {
            responseData.setBranch(null);
            responseData.setResponseMessage("UserNotInSampleSpace");
            return responseData;
        }
        Date now = new Date();
        if (!expConfig.getEnabled().booleanValue() || expConfig.getStart_time() != null && expConfig.getStart_time().after(now) || expConfig.getEnd_time() != null && expConfig.getEnd_time().before(now)) {
            responseData.setBranch(null);
            if (!expConfig.getEnabled().booleanValue()) {
                responseData.setResponseMessage("ExperimentNotEnabled");
            } else if (expConfig.getStart_time() != null && expConfig.getStart_time().after(now)) {
                responseData.setResponseMessage("ExperimentNotStartedYet");
            } else if (expConfig.getEnd_time() != null && expConfig.getEnd_time().before(now)) {
                responseData.setResponseMessage("ExperimentExpired");
            } else {
                LOGGER.error("ERROR: Unreachable block; Missing error message?");
                responseData.setResponseMessage("ERROR");
            }
            return responseData;
        }
        if (requestABId == null || !this.abIDTable.containsKey(requestABId)) {
            ABIdTable abIdTableData;
            String branch = forceAssignBranch;
            String abValue = null;
            if (branch != null && !branch.isEmpty()) {
                responseData.setBranch(branch);
                abIdTableData = new ABIdTable(expID, branch, expConfig.getVersion());
                abValue = abIdTableData.getABValue();
            }
            if (branch == null || branch.isEmpty() || !this.abIDTable.containsKey(abValue)) {
                ExperimentDistribution experimentDistribution = ConmanConfigStore.getInstance().getExperimentDistribution(expConfig.getType());
                branch = experimentDistribution.computeBranch(expConfig.getBranches());
                if (branch == null) {
                    responseData.setResponseMessage("BranchesProbabilitySumLessThan100");
                    return responseData;
                }
                responseData.setBranch(branch);
                abIdTableData = new ABIdTable(expID, branch, expConfig.getVersion());
                abValue = abIdTableData.getABValue();
            }
            if (!this.abIDTable.containsKey(abValue)) {
                LOGGER.error("Critical: this block must have been unreachable, abvalue: " + abValue + " not found in abIDTable!!");
                responseData.setResponseMessage("ERROR");
                return responseData;
            }
            responseData.setAbID(this.abIDTable.get(abValue));
        }
        responseData.setPostMetadata(expConfig.getPostMetadata().get(responseData.getBranch()));
        responseData.setExpiry(expConfig.getExpiryType());
        responseData.setVersion(expConfig.getVersion());
        return responseData;
    }

    public void addExperimentToABIdTable(ABExperimentConfig expConfig) {
        if (expConfig == null) {
            return;
        }
        ABIdTable abIdTableData = new ABIdTable(expConfig.getExp_id(), null, expConfig.getVersion());
        for (String branch : expConfig.getBranches().keySet()) {
            abIdTableData.setBranch(branch);
            String abValue = abIdTableData.getABValue();
            String abID = abIdTableData.getHashedABID();
            this.abIDTable.put(abID, abValue);
            this.abIDTable.put(abValue, abID);
            LOGGER.info("adding to abIDTable - abID: " + abID + ", abValue: " + abValue);
        }
    }

    public void removeExperimentFromABIdTable(ABExperimentConfig expConfig) {
        if (expConfig == null) {
            return;
        }
        ABIdTable abIdTableData = new ABIdTable(expConfig.getExp_id(), null, expConfig.getVersion());
        for (String branch : expConfig.getBranches().keySet()) {
            abIdTableData.setBranch(branch);
            String abValue = abIdTableData.getABValue();
            String abID = abIdTableData.getHashedABID();
            this.abIDTable.remove(abID);
            this.abIDTable.remove(abValue);
            LOGGER.info("removing from abIDTable(old config) - abID: " + abID + ", abValue: " + abValue);
        }
    }

    public ABResponseWithJunction getABWithJunction(ABRequestWithJunction requestData) {
        Map<String, String> junctionConfig;
        ABResponseWithJunction responseData = new ABResponseWithJunction();
        responseData.setResponseMessage("OK");
        String requestABId = requestData.getAbID();
        String expID = requestData.getExperimentID();
        String forceAssignBranch = requestData.getForceAssignBranch();
        String junctionName = requestData.getJunctionName();
        String junctionType = requestData.getJunctionType();
        responseData.setAbID(requestABId);
        responseData.setExpID(expID);
        ABExperimentConfig expConfig = null;
        if (requestABId != null && this.abIDTable.containsKey(requestABId)) {
            String abValue = this.abIDTable.get(requestABId);
            ABIdTable abIdTableData = new ABIdTable(abValue);
            expID = abIdTableData.getExpID();
            responseData.setExpID(expID);
            responseData.setBranch(abIdTableData.getBranch());
            responseData.setAbID(requestABId);
        }
        if (expID != null) {
            expConfig = this.experimentConfigStore.getExperimentConfig(expID);
        }
        if (expConfig == null) {
            responseData.setBranch(null);
            if (junctionName != null && junctionType != null) {
                for (ABExperimentConfig experimentConfig : this.experimentConfigStore.getAllExperimentConfig().values()) {
                    if (!experimentConfig.getJunctions().containsKey(junctionType + ":" + junctionName)) continue;
                    responseData.setExpID(experimentConfig.getExp_id());
                    return responseData;
                }
            }
            responseData.setResponseMessage("ExperimentConfigDoesNotExist");
            return responseData;
        }
        if (expConfig.getUserVerification() != null && !expConfig.getUserVerification().userLiesInSampleSpace(expID, expConfig.getPreMetadata(), requestData.getUserContext()).booleanValue()) {
            responseData.setBranch(null);
            responseData.setResponseMessage("UserNotInSampleSpace");
            return responseData;
        }
        Date now = new Date();
        if (!expConfig.getEnabled().booleanValue() || expConfig.getStart_time() != null && expConfig.getStart_time().after(now) || expConfig.getEnd_time() != null && expConfig.getEnd_time().before(now)) {
            responseData.setBranch(null);
            if (!expConfig.getEnabled().booleanValue()) {
                responseData.setResponseMessage("ExperimentNotEnabled");
            } else if (expConfig.getStart_time() != null && expConfig.getStart_time().after(now)) {
                responseData.setResponseMessage("ExperimentNotStartedYet");
            } else if (expConfig.getEnd_time() != null && expConfig.getEnd_time().before(now)) {
                responseData.setResponseMessage("ExperimentExpired");
            } else {
                LOGGER.error("ERROR: Unreachable block; Missing error message?");
                responseData.setResponseMessage("ERROR");
            }
            return responseData;
        }
        if (requestABId == null || !this.abIDTable.containsKey(requestABId)) {
            ABIdTable abIdTableData;
            String branch = forceAssignBranch;
            String abValue = null;
            if (branch != null && !branch.isEmpty()) {
                responseData.setBranch(branch);
                abIdTableData = new ABIdTable(expID, branch, expConfig.getVersion());
                abValue = abIdTableData.getABValue();
            }
            if (branch == null || branch.isEmpty() || !this.abIDTable.containsKey(abValue)) {
                ExperimentDistribution experimentDistribution = ConmanConfigStore.getInstance().getExperimentDistribution(expConfig.getType());
                branch = experimentDistribution.computeBranch(expConfig.getBranches());
                if (branch == null) {
                    responseData.setResponseMessage("BranchesProbabilitySumLessThan100");
                    return responseData;
                }
                responseData.setBranch(branch);
                abIdTableData = new ABIdTable(expID, branch, expConfig.getVersion());
                abValue = abIdTableData.getABValue();
            }
            if (!this.abIDTable.containsKey(abValue)) {
                LOGGER.error("Critical: this block must have been unreachable, abvalue: " + abValue + " not found in abIDTable!!");
                responseData.setResponseMessage("ERROR");
                return responseData;
            }
            responseData.setAbID(this.abIDTable.get(abValue));
            ArrayList<String> listJunctions = new ArrayList<String>();
            for (String junctionNameType : expConfig.getJunctions().keySet()) {
                listJunctions.add(junctionNameType);
            }
            responseData.setJunctionNames(listJunctions);
        }
        responseData.setPostMetadata(expConfig.getPostMetadata().get(responseData.getBranch()));
        responseData.setExpiry(expConfig.getExpiryType());
        responseData.setVersion(expConfig.getVersion());
        if (junctionName != null && junctionType != null && (junctionConfig = expConfig.getJunctions().get(junctionType + ":" + junctionName)).containsKey(responseData.getBranch())) {
            responseData.setBranchValue(junctionConfig.get(responseData.getBranch()));
        }
        return responseData;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ABService.class);
    }
}

