/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.abservice.pojo;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.abservice.resources.UserVerification;
import com.flipkart.abservice.resources.impl.UserVerificationDefaultImpl;
import com.flipkart.abservice.rulesEngine.Expression;
import com.flipkart.abservice.rulesEngine.ExpressionParser;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ABExperimentConfig {
    String name;
    String exp_id;
    String type = "RandomProbability";
    Map<String, Integer> branches = new HashMap<String, Integer>();
    String preMetadata = null;
    Map<String, Map<String, String>> postMetadata = new HashMap<String, Map<String, String>>();
    String version = "0";
    Date start_time = null;
    Date end_time = null;
    Boolean enabled = true;
    Map<String, Map<String, String>> junctions = new HashMap<String, Map<String, String>>();
    String expiryType;
    UserVerification userVerification = null;
    Expression userVerificationExpression = null;

    public Map<String, Map<String, String>> getJunctions() {
        return this.junctions;
    }

    public String getExpiryType() {
        return this.expiryType;
    }

    public UserVerification getUserVerification() {
        return this.userVerification;
    }

    public void setUserVerification(UserVerification userVerification) {
        this.userVerification = userVerification;
    }

    public Expression getUserVerificationExpression() {
        return this.userVerificationExpression;
    }

    public void setUserVerificationExpression(Expression userVerificationExpression) {
        this.userVerificationExpression = userVerificationExpression;
    }

    public String getName() {
        return this.name;
    }

    public String getExp_id() {
        return this.exp_id;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Integer> getBranches() {
        return this.branches;
    }

    public String getPreMetadata() {
        return this.preMetadata;
    }

    public Map<String, Map<String, String>> getPostMetadata() {
        return this.postMetadata;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getStart_time() {
        return this.start_time;
    }

    public Date getEnd_time() {
        return this.end_time;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean setConfigFromJson(String jsonConfig) {
        if (this.userVerification == null) {
            this.userVerification = new UserVerificationDefaultImpl();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Map configMap = (Map)objectMapper.readValue(jsonConfig, Map.class);
            if (!configMap.containsKey("name") || !configMap.containsKey("branches")) {
                return false;
            }
            this.exp_id = this.name = (String)configMap.get("name");
            this.branches = (Map)configMap.get("branches");
            if (configMap.containsKey("version")) {
                this.version = String.valueOf(configMap.get("version"));
            }
            if (configMap.containsKey("type")) {
                this.type = (String)configMap.get("type");
            }
            if (configMap.containsKey("enabled")) {
                this.enabled = (Boolean)configMap.get("enabled");
            }
            if (configMap.containsKey("preMetadata")) {
                this.preMetadata = (String)configMap.get("preMetadata");
                this.userVerificationExpression = ExpressionParser.fromString(this.preMetadata);
            }
            if (configMap.containsKey("variables")) {
                this.postMetadata = (Map)configMap.get("variables");
            }
            if (configMap.containsKey("expiry")) {
                this.expiryType = (String)configMap.get("expiry");
            }
            if (configMap.containsKey("junctions")) {
                List junctions = (List)configMap.get("junctions");
                for (Map junction : junctions) {
                    if (!junction.containsKey("name") || !junction.containsKey("type") || !junction.containsKey("branches")) continue;
                    String junctionName = (String)junction.get("type") + ":" + junction.get("name");
                    this.junctions.put(junctionName, (Map)junction.get("branches"));
                }
            }
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy:MM:dd-HH:mm:ss");
                if (configMap.containsKey("start_time")) {
                    this.start_time = formatter.parse((String)configMap.get("start_time"));
                }
                if (configMap.containsKey("end_time")) {
                    this.end_time = formatter.parse((String)configMap.get("end_time"));
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

